## Playlists

There are several versions of playlists that differ in the way they are grouped. As of January 30th, 2024, we have stopped distributing NSFW channels. For more information, please look at [this issue](https://github.com/iptv-org/iptv/issues/15723).

### Grouped by category

Playlists in which channels are grouped by category.

<details>
<summary>Expand</summary>
<br>

```
https://iptv-org.github.io/iptv/index.category.m3u
```

Same thing, but split up into separate files:

<!-- prettier-ignore -->
<table>
  <thead>
    <tr><th align="left">Category</th><th align="left">Channels</th><th align="left">Playlist</th></tr>
  </thead>
  <tbody>
    <tr><td>Animation</td><td align="right">62</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/animation.m3u</code></td></tr>
    <tr><td>Auto</td><td align="right">19</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/auto.m3u</code></td></tr>
    <tr><td>Business</td><td align="right">66</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/business.m3u</code></td></tr>
    <tr><td>Classic</td><td align="right">49</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/classic.m3u</code></td></tr>
    <tr><td>Comedy</td><td align="right">86</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/comedy.m3u</code></td></tr>
    <tr><td>Cooking</td><td align="right">37</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/cooking.m3u</code></td></tr>
    <tr><td>Culture</td><td align="right">175</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/culture.m3u</code></td></tr>
    <tr><td>Documentary</td><td align="right">125</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/documentary.m3u</code></td></tr>
    <tr><td>Education</td><td align="right">178</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/education.m3u</code></td></tr>
    <tr><td>Entertainment</td><td align="right">642</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/entertainment.m3u</code></td></tr>
    <tr><td>Family</td><td align="right">55</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/family.m3u</code></td></tr>
    <tr><td>General</td><td align="right">2535</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/general.m3u</code></td></tr>
    <tr><td>Interactive</td><td align="right">1</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/interactive.m3u</code></td></tr>
    <tr><td>Kids</td><td align="right">279</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/kids.m3u</code></td></tr>
    <tr><td>Legislative</td><td align="right">190</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/legislative.m3u</code></td></tr>
    <tr><td>Lifestyle</td><td align="right">110</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/lifestyle.m3u</code></td></tr>
    <tr><td>Movies</td><td align="right">385</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/movies.m3u</code></td></tr>
    <tr><td>Music</td><td align="right">652</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/music.m3u</code></td></tr>
    <tr><td>News</td><td align="right">892</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/news.m3u</code></td></tr>
    <tr><td>Outdoor</td><td align="right">44</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/outdoor.m3u</code></td></tr>
    <tr><td>Public</td><td align="right">41</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/public.m3u</code></td></tr>
    <tr><td>Relax</td><td align="right">3</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/relax.m3u</code></td></tr>
    <tr><td>Religious</td><td align="right">744</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/religious.m3u</code></td></tr>
    <tr><td>Science</td><td align="right">25</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/science.m3u</code></td></tr>
    <tr><td>Series</td><td align="right">271</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/series.m3u</code></td></tr>
    <tr><td>Shop</td><td align="right">89</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/shop.m3u</code></td></tr>
    <tr><td>Sports</td><td align="right">345</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/sports.m3u</code></td></tr>
    <tr><td>Travel</td><td align="right">42</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/travel.m3u</code></td></tr>
    <tr><td>Weather</td><td align="right">17</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/weather.m3u</code></td></tr>
    <tr><td>XXX</td><td align="right">0</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/xxx.m3u</code></td></tr>
    <tr><td>Undefined</td><td align="right">3726</td><td nowrap><code>https://iptv-org.github.io/iptv/categories/undefined.m3u</code></td></tr>
  </tbody>
</table>

</details>

### Grouped by language

Playlists in which channels are grouped by the language in which they are broadcast.

<details>
<summary>Expand</summary>
<br>

```
https://iptv-org.github.io/iptv/index.language.m3u
```

Same thing, but split up into separate files:

<!-- prettier-ignore -->
<table>
  <thead>
    <tr><th align="left">Language</th><th align="left">Channels</th><th align="left">Playlist</th></tr>
  </thead>
  <tbody>
    <tr><td align="left">Acoli</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ach.m3u</code></td></tr>
    <tr><td align="left">Adhola</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/adh.m3u</code></td></tr>
    <tr><td align="left">Afar</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/aar.m3u</code></td></tr>
    <tr><td align="left">Afrikaans</td><td align="right">6</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/afr.m3u</code></td></tr>
    <tr><td align="left">Albanian</td><td align="right">45</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/sqi.m3u</code></td></tr>
    <tr><td align="left">Alemannic</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/gsw.m3u</code></td></tr>
    <tr><td align="left">Algerian Sign Language</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/asp.m3u</code></td></tr>
    <tr><td align="left">Alur</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/alz.m3u</code></td></tr>
    <tr><td align="left">Amharic</td><td align="right">8</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/amh.m3u</code></td></tr>
    <tr><td align="left">Arabic</td><td align="right">471</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ara.m3u</code></td></tr>
    <tr><td align="left">Armenian</td><td align="right">7</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/hye.m3u</code></td></tr>
    <tr><td align="left">Assamese</td><td align="right">9</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/asm.m3u</code></td></tr>
    <tr><td align="left">Assyrian Neo-Aramaic</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/aii.m3u</code></td></tr>
    <tr><td align="left">Ayizo Gbe</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ayb.m3u</code></td></tr>
    <tr><td align="left">Aymara</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/aym.m3u</code></td></tr>
    <tr><td align="left">Azerbaijani</td><td align="right">17</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/aze.m3u</code></td></tr>
    <tr><td align="left">Baatonum</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/bba.m3u</code></td></tr>
    <tr><td align="left">Bambara</td><td align="right">5</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/bam.m3u</code></td></tr>
    <tr><td align="left">Bashkir</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/bak.m3u</code></td></tr>
    <tr><td align="left">Basque</td><td align="right">6</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/eus.m3u</code></td></tr>
    <tr><td align="left">Belarusian</td><td align="right">4</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/bel.m3u</code></td></tr>
    <tr><td align="left">Bengali</td><td align="right">55</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ben.m3u</code></td></tr>
    <tr><td align="left">Bhojpuri</td><td align="right">6</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/bho.m3u</code></td></tr>
    <tr><td align="left">Bisa</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/bib.m3u</code></td></tr>
    <tr><td align="left">Bosnian</td><td align="right">14</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/bos.m3u</code></td></tr>
    <tr><td align="left">Buamu</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/box.m3u</code></td></tr>
    <tr><td align="left">Bulgarian</td><td align="right">24</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/bul.m3u</code></td></tr>
    <tr><td align="left">Burmese</td><td align="right">6</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mya.m3u</code></td></tr>
    <tr><td align="left">Catalan</td><td align="right">63</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/cat.m3u</code></td></tr>
    <tr><td align="left">Central Atlas Tamazight</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tzm.m3u</code></td></tr>
    <tr><td align="left">Central Kurdish</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ckb.m3u</code></td></tr>
    <tr><td align="left">Chenoua</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/cnu.m3u</code></td></tr>
    <tr><td align="left">Chewa</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/nya.m3u</code></td></tr>
    <tr><td align="left">Chhattisgarhi</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/hne.m3u</code></td></tr>
    <tr><td align="left">Chiga</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/cgg.m3u</code></td></tr>
    <tr><td align="left">Chinese</td><td align="right">223</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/zho.m3u</code></td></tr>
    <tr><td align="left">Croatian</td><td align="right">27</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/hrv.m3u</code></td></tr>
    <tr><td align="left">Czech</td><td align="right">32</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ces.m3u</code></td></tr>
    <tr><td align="left">Danish</td><td align="right">12</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/dan.m3u</code></td></tr>
    <tr><td align="left">Dari (Parsi)</td><td align="right">16</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/prd.m3u</code></td></tr>
    <tr><td align="left">Dhanwar (Nepal)</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/dhw.m3u</code></td></tr>
    <tr><td align="left">Dhivehi</td><td align="right">10</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/div.m3u</code></td></tr>
    <tr><td align="left">Dholuo</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/luo.m3u</code></td></tr>
    <tr><td align="left">Dimili</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/zza.m3u</code></td></tr>
    <tr><td align="left">Dutch</td><td align="right">179</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/nld.m3u</code></td></tr>
    <tr><td align="left">Dyula</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/dyu.m3u</code></td></tr>
    <tr><td align="left">Egyptian Arabic</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/arz.m3u</code></td></tr>
    <tr><td align="left">English</td><td align="right">2498</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/eng.m3u</code></td></tr>
    <tr><td align="left">Estonian</td><td align="right">9</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/est.m3u</code></td></tr>
    <tr><td align="left">Ewe</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ewe.m3u</code></td></tr>
    <tr><td align="left">Faroese</td><td align="right">3</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/fao.m3u</code></td></tr>
    <tr><td align="left">Fataleka</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/far.m3u</code></td></tr>
    <tr><td align="left">Finnish</td><td align="right">16</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/fin.m3u</code></td></tr>
    <tr><td align="left">Fon</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/fon.m3u</code></td></tr>
    <tr><td align="left">French</td><td align="right">549</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/fra.m3u</code></td></tr>
    <tr><td align="left">Fulah</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ful.m3u</code></td></tr>
    <tr><td align="left">Gaelic</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/gla.m3u</code></td></tr>
    <tr><td align="left">Galician</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/glg.m3u</code></td></tr>
    <tr><td align="left">Ganda</td><td align="right">12</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/lug.m3u</code></td></tr>
    <tr><td align="left">Gen</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/gej.m3u</code></td></tr>
    <tr><td align="left">Georgian</td><td align="right">22</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kat.m3u</code></td></tr>
    <tr><td align="left">German</td><td align="right">339</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/deu.m3u</code></td></tr>
    <tr><td align="left">Gikuyu</td><td align="right">3</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kik.m3u</code></td></tr>
    <tr><td align="left">Goan Konkani</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/gom.m3u</code></td></tr>
    <tr><td align="left">Gourmanchéma</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/gux.m3u</code></td></tr>
    <tr><td align="left">Greek</td><td align="right">124</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ell.m3u</code></td></tr>
    <tr><td align="left">Guadeloupean Creole French</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/gcf.m3u</code></td></tr>
    <tr><td align="left">Gujarati</td><td align="right">10</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/guj.m3u</code></td></tr>
    <tr><td align="left">Gun</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/guw.m3u</code></td></tr>
    <tr><td align="left">Haitian</td><td align="right">16</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/hat.m3u</code></td></tr>
    <tr><td align="left">Hausa</td><td align="right">8</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/hau.m3u</code></td></tr>
    <tr><td align="left">Hebrew</td><td align="right">16</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/heb.m3u</code></td></tr>
    <tr><td align="left">Hindi</td><td align="right">222</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/hin.m3u</code></td></tr>
    <tr><td align="left">Hmong</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/hmn.m3u</code></td></tr>
    <tr><td align="left">Hungarian</td><td align="right">103</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/hun.m3u</code></td></tr>
    <tr><td align="left">Icelandic</td><td align="right">5</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/isl.m3u</code></td></tr>
    <tr><td align="left">Indonesian</td><td align="right">169</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ind.m3u</code></td></tr>
    <tr><td align="left">Inuktitut</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/iku.m3u</code></td></tr>
    <tr><td align="left">Irish</td><td align="right">3</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/gle.m3u</code></td></tr>
    <tr><td align="left">Isekiri</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/its.m3u</code></td></tr>
    <tr><td align="left">Italian</td><td align="right">366</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ita.m3u</code></td></tr>
    <tr><td align="left">Japanese</td><td align="right">25</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/jpn.m3u</code></td></tr>
    <tr><td align="left">Javanese</td><td align="right">4</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/jav.m3u</code></td></tr>
    <tr><td align="left">Kabiyè</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kbp.m3u</code></td></tr>
    <tr><td align="left">Kabyle</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kab.m3u</code></td></tr>
    <tr><td align="left">Kannada</td><td align="right">28</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kan.m3u</code></td></tr>
    <tr><td align="left">Kapampangan</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/pam.m3u</code></td></tr>
    <tr><td align="left">Kazakh</td><td align="right">27</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kaz.m3u</code></td></tr>
    <tr><td align="left">Khmer</td><td align="right">25</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/khm.m3u</code></td></tr>
    <tr><td align="left">Khorasani Turkish</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kmz.m3u</code></td></tr>
    <tr><td align="left">Kinyarwanda</td><td align="right">9</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kin.m3u</code></td></tr>
    <tr><td align="left">Kirghiz</td><td align="right">13</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kir.m3u</code></td></tr>
    <tr><td align="left">Kiswahili</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/swh.m3u</code></td></tr>
    <tr><td align="left">Kituba (Congo)</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mkw.m3u</code></td></tr>
    <tr><td align="left">Konabéré</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/bbo.m3u</code></td></tr>
    <tr><td align="left">Kongo</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kon.m3u</code></td></tr>
    <tr><td align="left">Konkani (macrolanguage)</td><td align="right">3</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kok.m3u</code></td></tr>
    <tr><td align="left">Korean</td><td align="right">88</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kor.m3u</code></td></tr>
    <tr><td align="left">Kumam</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kdi.m3u</code></td></tr>
    <tr><td align="left">Kurdish</td><td align="right">32</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/kur.m3u</code></td></tr>
    <tr><td align="left">Lango (Uganda)</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/laj.m3u</code></td></tr>
    <tr><td align="left">Lao</td><td align="right">6</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/lao.m3u</code></td></tr>
    <tr><td align="left">Latin</td><td align="right">4</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/lat.m3u</code></td></tr>
    <tr><td align="left">Latvian</td><td align="right">7</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/lav.m3u</code></td></tr>
    <tr><td align="left">Letzeburgesch</td><td align="right">12</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ltz.m3u</code></td></tr>
    <tr><td align="left">Lingala</td><td align="right">6</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/lin.m3u</code></td></tr>
    <tr><td align="left">Lithuanian</td><td align="right">5</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/lit.m3u</code></td></tr>
    <tr><td align="left">Lobi</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/lob.m3u</code></td></tr>
    <tr><td align="left">Luba-Lulua</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/lua.m3u</code></td></tr>
    <tr><td align="left">Lusengo</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/lse.m3u</code></td></tr>
    <tr><td align="left">Lushai</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/lus.m3u</code></td></tr>
    <tr><td align="left">Lyélé</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/lee.m3u</code></td></tr>
    <tr><td align="left">Macedonian</td><td align="right">33</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mkd.m3u</code></td></tr>
    <tr><td align="left">Maithili</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mai.m3u</code></td></tr>
    <tr><td align="left">Malagasy</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mlg.m3u</code></td></tr>
    <tr><td align="left">Malay</td><td align="right">17</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/msa.m3u</code></td></tr>
    <tr><td align="left">Malayalam</td><td align="right">84</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mal.m3u</code></td></tr>
    <tr><td align="left">Maltese</td><td align="right">5</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mlt.m3u</code></td></tr>
    <tr><td align="left">Mandarin Chinese</td><td align="right">6</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/cmn.m3u</code></td></tr>
    <tr><td align="left">Manding</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/man.m3u</code></td></tr>
    <tr><td align="left">Mandinka</td><td align="right">3</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mnk.m3u</code></td></tr>
    <tr><td align="left">Maori</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mri.m3u</code></td></tr>
    <tr><td align="left">Marathi</td><td align="right">21</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mar.m3u</code></td></tr>
    <tr><td align="left">Marka</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/rkm.m3u</code></td></tr>
    <tr><td align="left">Matya Samo</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/stj.m3u</code></td></tr>
    <tr><td align="left">Maya Samo</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/sym.m3u</code></td></tr>
    <tr><td align="left">Min Nan Chinese</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/nan.m3u</code></td></tr>
    <tr><td align="left">Mongolian</td><td align="right">46</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mon.m3u</code></td></tr>
    <tr><td align="left">Montenegrin</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/cnr.m3u</code></td></tr>
    <tr><td align="left">Morisyen</td><td align="right">3</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mfe.m3u</code></td></tr>
    <tr><td align="left">Moroccan Sign Language</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/xms.m3u</code></td></tr>
    <tr><td align="left">Mossi</td><td align="right">3</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mos.m3u</code></td></tr>
    <tr><td align="left">Mycenaean Greek</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/gmy.m3u</code></td></tr>
    <tr><td align="left">Nepali</td><td align="right">7</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/nep.m3u</code></td></tr>
    <tr><td align="left">North Ndebele</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/nde.m3u</code></td></tr>
    <tr><td align="left">Northern Dagara</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/dgi.m3u</code></td></tr>
    <tr><td align="left">Norwegian</td><td align="right">9</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/nor.m3u</code></td></tr>
    <tr><td align="left">Nyankole</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/nyn.m3u</code></td></tr>
    <tr><td align="left">Nyoro</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/nyo.m3u</code></td></tr>
    <tr><td align="left">Oriya (macrolanguage)</td><td align="right">14</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ori.m3u</code></td></tr>
    <tr><td align="left">Oromo</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/orm.m3u</code></td></tr>
    <tr><td align="left">Panjabi</td><td align="right">33</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/pan.m3u</code></td></tr>
    <tr><td align="left">Papiamento</td><td align="right">17</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/pap.m3u</code></td></tr>
    <tr><td align="left">Pashto</td><td align="right">26</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/pus.m3u</code></td></tr>
    <tr><td align="left">Persian</td><td align="right">224</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/fas.m3u</code></td></tr>
    <tr><td align="left">Polish</td><td align="right">81</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/pol.m3u</code></td></tr>
    <tr><td align="left">Portuguese</td><td align="right">256</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/por.m3u</code></td></tr>
    <tr><td align="left">Pulaar</td><td align="right">6</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/fuc.m3u</code></td></tr>
    <tr><td align="left">Pular</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/fuf.m3u</code></td></tr>
    <tr><td align="left">Quechua</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/que.m3u</code></td></tr>
    <tr><td align="left">Romanian</td><td align="right">99</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ron.m3u</code></td></tr>
    <tr><td align="left">Rundi</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/run.m3u</code></td></tr>
    <tr><td align="left">Russian</td><td align="right">354</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/rus.m3u</code></td></tr>
    <tr><td align="left">Saint Lucian Creole French</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/acf.m3u</code></td></tr>
    <tr><td align="left">Samoan</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/smo.m3u</code></td></tr>
    <tr><td align="left">Sango</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/sag.m3u</code></td></tr>
    <tr><td align="left">Santali</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/sat.m3u</code></td></tr>
    <tr><td align="left">Serbian</td><td align="right">52</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/srp.m3u</code></td></tr>
    <tr><td align="left">Serbo-Croatian</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/hbs.m3u</code></td></tr>
    <tr><td align="left">Shona</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/sna.m3u</code></td></tr>
    <tr><td align="left">Sinhala</td><td align="right">14</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/sin.m3u</code></td></tr>
    <tr><td align="left">Slovak</td><td align="right">35</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/slk.m3u</code></td></tr>
    <tr><td align="left">Slovenian</td><td align="right">15</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/slv.m3u</code></td></tr>
    <tr><td align="left">Somali</td><td align="right">17</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/som.m3u</code></td></tr>
    <tr><td align="left">Soninke</td><td align="right">3</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/snk.m3u</code></td></tr>
    <tr><td align="left">South African Sign Language</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/sfs.m3u</code></td></tr>
    <tr><td align="left">South Ndebele</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/nbl.m3u</code></td></tr>
    <tr><td align="left">Southern Samo</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/sbd.m3u</code></td></tr>
    <tr><td align="left">Spanish</td><td align="right">1788</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/spa.m3u</code></td></tr>
    <tr><td align="left">Standard Arabic</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/arb.m3u</code></td></tr>
    <tr><td align="left">Sundanese</td><td align="right">3</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/sun.m3u</code></td></tr>
    <tr><td align="left">Swahili</td><td align="right">38</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/swa.m3u</code></td></tr>
    <tr><td align="left">Swati</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ssw.m3u</code></td></tr>
    <tr><td align="left">Swedish</td><td align="right">12</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/swe.m3u</code></td></tr>
    <tr><td align="left">Tachawit</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/shy.m3u</code></td></tr>
    <tr><td align="left">Tachelhit</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/shi.m3u</code></td></tr>
    <tr><td align="left">Tagalog</td><td align="right">3</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tgl.m3u</code></td></tr>
    <tr><td align="left">Tahitian</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tah.m3u</code></td></tr>
    <tr><td align="left">Tajik</td><td align="right">15</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tgk.m3u</code></td></tr>
    <tr><td align="left">Tamashek</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tmh.m3u</code></td></tr>
    <tr><td align="left">Tamasheq</td><td align="right">2</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/taq.m3u</code></td></tr>
    <tr><td align="left">Tamil</td><td align="right">103</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tam.m3u</code></td></tr>
    <tr><td align="left">Tarifit</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/rif.m3u</code></td></tr>
    <tr><td align="left">Tatar</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tat.m3u</code></td></tr>
    <tr><td align="left">Telugu</td><td align="right">57</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tel.m3u</code></td></tr>
    <tr><td align="left">Thai</td><td align="right">70</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tha.m3u</code></td></tr>
    <tr><td align="left">Tibetan</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/bod.m3u</code></td></tr>
    <tr><td align="left">Tigre</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tig.m3u</code></td></tr>
    <tr><td align="left">Tigrinya</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tir.m3u</code></td></tr>
    <tr><td align="left">Tooro</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ttj.m3u</code></td></tr>
    <tr><td align="left">Tsonga</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tso.m3u</code></td></tr>
    <tr><td align="left">Tswana</td><td align="right">4</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tsn.m3u</code></td></tr>
    <tr><td align="left">Tumzabt</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/mzb.m3u</code></td></tr>
    <tr><td align="left">Turkish</td><td align="right">234</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tur.m3u</code></td></tr>
    <tr><td align="left">Turkmen</td><td align="right">8</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/tuk.m3u</code></td></tr>
    <tr><td align="left">Uighur</td><td align="right">3</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/uig.m3u</code></td></tr>
    <tr><td align="left">Ukrainian</td><td align="right">73</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ukr.m3u</code></td></tr>
    <tr><td align="left">Urdu</td><td align="right">55</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/urd.m3u</code></td></tr>
    <tr><td align="left">Uzbek</td><td align="right">24</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/uzb.m3u</code></td></tr>
    <tr><td align="left">Venda</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/ven.m3u</code></td></tr>
    <tr><td align="left">Vietnamese</td><td align="right">82</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/vie.m3u</code></td></tr>
    <tr><td align="left">Welsh</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/cym.m3u</code></td></tr>
    <tr><td align="left">Western Frisian</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/fry.m3u</code></td></tr>
    <tr><td align="left">Western Niger Fulfulde</td><td align="right">4</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/fuh.m3u</code></td></tr>
    <tr><td align="left">Wolof</td><td align="right">17</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/wol.m3u</code></td></tr>
    <tr><td align="left">Xhosa</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/xho.m3u</code></td></tr>
    <tr><td align="left">Yakut</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/sah.m3u</code></td></tr>
    <tr><td align="left">Yoruba</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/yor.m3u</code></td></tr>
    <tr><td align="left">Yucatec Maya</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/yua.m3u</code></td></tr>
    <tr><td align="left">Yue Chinese</td><td align="right">6</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/yue.m3u</code></td></tr>
    <tr><td align="left">Zarma</td><td align="right">4</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/dje.m3u</code></td></tr>
    <tr><td align="left">Zulu</td><td align="right">1</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/zul.m3u</code></td></tr>
    <tr><td align="left">Undefined</td><td align="right">2221</td><td align="left" nowrap><code>https://iptv-org.github.io/iptv/languages/undefined.m3u</code></td></tr>
  </tbody>
</table>

</details>

### Grouped by broadcast area

Playlists in which channels are grouped by broadcast area.

<details>
<summary>Expand</summary>

#### Countries

```
https://iptv-org.github.io/iptv/index.country.m3u
```

Same thing, but split up into separate files:

<!-- prettier-ignore -->
- 🇦🇫 Afghanistan <code>https://iptv-org.github.io/iptv/countries/af.m3u</code>
- 🇦🇱 Albania <code>https://iptv-org.github.io/iptv/countries/al.m3u</code>
- 🇩🇿 Algeria <code>https://iptv-org.github.io/iptv/countries/dz.m3u</code>
- 🇦🇩 Andorra <code>https://iptv-org.github.io/iptv/countries/ad.m3u</code>
- 🇦🇴 Angola <code>https://iptv-org.github.io/iptv/countries/ao.m3u</code>
- 🇦🇷 Argentina <code>https://iptv-org.github.io/iptv/countries/ar.m3u</code>
  - Buenos Aires <code>https://iptv-org.github.io/iptv/subdivisions/ar-b.m3u</code>
    - Bahía Blanca <code>https://iptv-org.github.io/iptv/cities/arbhi.m3u</code>
    - La Plata <code>https://iptv-org.github.io/iptv/cities/arlpg.m3u</code>
    - San Miguel <code>https://iptv-org.github.io/iptv/cities/arsmg.m3u</code>
    - San Pedro <code>https://iptv-org.github.io/iptv/cities/arsnp.m3u</code>
    - Santa Teresita <code>https://iptv-org.github.io/iptv/cities/arsst.m3u</code>
    - Tres Arroyos <code>https://iptv-org.github.io/iptv/cities/aroyo.m3u</code>
  - Catamarca <code>https://iptv-org.github.io/iptv/subdivisions/ar-k.m3u</code>
    - San Fernando del Valle de Catamarca <code>https://iptv-org.github.io/iptv/cities/arsfv.m3u</code>
  - Chaco <code>https://iptv-org.github.io/iptv/subdivisions/ar-h.m3u</code>
    - Resistencia <code>https://iptv-org.github.io/iptv/cities/arres.m3u</code>
  - Chubut <code>https://iptv-org.github.io/iptv/subdivisions/ar-u.m3u</code>
    - Trelew <code>https://iptv-org.github.io/iptv/cities/arrel.m3u</code>
  - Ciudad Autonoma de Buenos Aires <code>https://iptv-org.github.io/iptv/subdivisions/ar-c.m3u</code>
    - Buenos Aires <code>https://iptv-org.github.io/iptv/cities/arbue.m3u</code>
  - Cordoba <code>https://iptv-org.github.io/iptv/subdivisions/ar-x.m3u</code>
    - Villa María <code>https://iptv-org.github.io/iptv/cities/arvmr.m3u</code>
  - Corrientes <code>https://iptv-org.github.io/iptv/subdivisions/ar-w.m3u</code>
    - Corrientes <code>https://iptv-org.github.io/iptv/cities/arcnq.m3u</code>
  - Entre Rios <code>https://iptv-org.github.io/iptv/subdivisions/ar-e.m3u</code>
  - Formosa <code>https://iptv-org.github.io/iptv/subdivisions/ar-p.m3u</code>
    - Formosa <code>https://iptv-org.github.io/iptv/cities/arfma.m3u</code>
  - Jujuy <code>https://iptv-org.github.io/iptv/subdivisions/ar-y.m3u</code>
    - San Salvador de Jujuy <code>https://iptv-org.github.io/iptv/cities/arssj.m3u</code>
  - La Pampa <code>https://iptv-org.github.io/iptv/subdivisions/ar-l.m3u</code>
    - Santa Rosa <code>https://iptv-org.github.io/iptv/cities/arrsa.m3u</code>
  - La Rioja <code>https://iptv-org.github.io/iptv/subdivisions/ar-f.m3u</code>
  - Misiones <code>https://iptv-org.github.io/iptv/subdivisions/ar-n.m3u</code>
    - Posadas <code>https://iptv-org.github.io/iptv/cities/arpss.m3u</code>
  - Neuquén <code>https://iptv-org.github.io/iptv/subdivisions/ar-q.m3u</code>
    - Neuquén <code>https://iptv-org.github.io/iptv/cities/arnqn.m3u</code>
  - Salta <code>https://iptv-org.github.io/iptv/subdivisions/ar-a.m3u</code>
    - Salta <code>https://iptv-org.github.io/iptv/cities/arsla.m3u</code>
  - San Juan <code>https://iptv-org.github.io/iptv/subdivisions/ar-j.m3u</code>
    - San Juan <code>https://iptv-org.github.io/iptv/cities/aruaq.m3u</code>
  - San Luis <code>https://iptv-org.github.io/iptv/subdivisions/ar-d.m3u</code>
    - San Luis <code>https://iptv-org.github.io/iptv/cities/arluq.m3u</code>
  - Santa Cruz <code>https://iptv-org.github.io/iptv/subdivisions/ar-z.m3u</code>
    - Las Heras <code>https://iptv-org.github.io/iptv/cities/arlhs.m3u</code>
    - Pico Truncado <code>https://iptv-org.github.io/iptv/cities/arjpt.m3u</code>
  - Santa Fe <code>https://iptv-org.github.io/iptv/subdivisions/ar-s.m3u</code>
    - Santa Fe <code>https://iptv-org.github.io/iptv/cities/arsfn.m3u</code>
    - Venado Tuerto <code>https://iptv-org.github.io/iptv/cities/arvnt.m3u</code>
  - Santiago del Estero <code>https://iptv-org.github.io/iptv/subdivisions/ar-g.m3u</code>
    - Santiago del Estero <code>https://iptv-org.github.io/iptv/cities/arsde.m3u</code>
  - Tucuman <code>https://iptv-org.github.io/iptv/subdivisions/ar-t.m3u</code>
    - San Miguel de Tucumán <code>https://iptv-org.github.io/iptv/cities/arsmc.m3u</code>
- 🇦🇲 Armenia <code>https://iptv-org.github.io/iptv/countries/am.m3u</code>
- 🇦🇼 Aruba <code>https://iptv-org.github.io/iptv/countries/aw.m3u</code>
- 🇦🇺 Australia <code>https://iptv-org.github.io/iptv/countries/au.m3u</code>
  - Australian Capital Territory <code>https://iptv-org.github.io/iptv/subdivisions/au-act.m3u</code>
  - New South Wales <code>https://iptv-org.github.io/iptv/subdivisions/au-nsw.m3u</code>
    - Sydney <code>https://iptv-org.github.io/iptv/cities/ausyd.m3u</code>
  - Northern Territory <code>https://iptv-org.github.io/iptv/subdivisions/au-nt.m3u</code>
  - Queensland <code>https://iptv-org.github.io/iptv/subdivisions/au-qld.m3u</code>
  - South Australia <code>https://iptv-org.github.io/iptv/subdivisions/au-sa.m3u</code>
  - Tasmania <code>https://iptv-org.github.io/iptv/subdivisions/au-tas.m3u</code>
  - Victoria <code>https://iptv-org.github.io/iptv/subdivisions/au-vic.m3u</code>
  - Western Australia <code>https://iptv-org.github.io/iptv/subdivisions/au-wa.m3u</code>
- 🇦🇹 Austria <code>https://iptv-org.github.io/iptv/countries/at.m3u</code>
  - Kärnten <code>https://iptv-org.github.io/iptv/subdivisions/at-2.m3u</code>
    - Klagenfurt <code>https://iptv-org.github.io/iptv/cities/atklu.m3u</code>
  - Steiermark <code>https://iptv-org.github.io/iptv/subdivisions/at-6.m3u</code>
    - Graz <code>https://iptv-org.github.io/iptv/cities/atgrz.m3u</code>
  - Tirol <code>https://iptv-org.github.io/iptv/subdivisions/at-7.m3u</code>
    - Innsbruck <code>https://iptv-org.github.io/iptv/cities/atinn.m3u</code>
- 🇦🇿 Azerbaijan <code>https://iptv-org.github.io/iptv/countries/az.m3u</code>
- 🇧🇸 Bahamas <code>https://iptv-org.github.io/iptv/countries/bs.m3u</code>
- 🇧🇭 Bahrain <code>https://iptv-org.github.io/iptv/countries/bh.m3u</code>
- 🇧🇩 Bangladesh <code>https://iptv-org.github.io/iptv/countries/bd.m3u</code>
- 🇧🇧 Barbados <code>https://iptv-org.github.io/iptv/countries/bb.m3u</code>
- 🇧🇾 Belarus <code>https://iptv-org.github.io/iptv/countries/by.m3u</code>
- 🇧🇪 Belgium <code>https://iptv-org.github.io/iptv/countries/be.m3u</code>
  - Antwerpen <code>https://iptv-org.github.io/iptv/subdivisions/be-van.m3u</code>
  - Vlaams Gewest <code>https://iptv-org.github.io/iptv/subdivisions/be-vlg.m3u</code>
- 🇧🇯 Benin <code>https://iptv-org.github.io/iptv/countries/bj.m3u</code>
- 🇧🇲 Bermuda <code>https://iptv-org.github.io/iptv/countries/bm.m3u</code>
- 🇧🇹 Bhutan <code>https://iptv-org.github.io/iptv/countries/bt.m3u</code>
- 🇧🇴 Bolivia <code>https://iptv-org.github.io/iptv/countries/bo.m3u</code>
  - Cochabamba <code>https://iptv-org.github.io/iptv/subdivisions/bo-c.m3u</code>
    - Cochabamba <code>https://iptv-org.github.io/iptv/cities/bocbb.m3u</code>
  - La Paz <code>https://iptv-org.github.io/iptv/subdivisions/bo-l.m3u</code>
  - Oruro <code>https://iptv-org.github.io/iptv/subdivisions/bo-o.m3u</code>
    - Oruro <code>https://iptv-org.github.io/iptv/cities/booru.m3u</code>
  - Santa Cruz <code>https://iptv-org.github.io/iptv/subdivisions/bo-s.m3u</code>
    - Santa Cruz de la Sierra <code>https://iptv-org.github.io/iptv/cities/boscs.m3u</code>
- 🇧🇶 Bonaire <code>https://iptv-org.github.io/iptv/countries/bq.m3u</code>
- 🇧🇦 Bosnia and Herzegovina <code>https://iptv-org.github.io/iptv/countries/ba.m3u</code>
- 🇧🇼 Botswana <code>https://iptv-org.github.io/iptv/countries/bw.m3u</code>
- 🇧🇷 Brazil <code>https://iptv-org.github.io/iptv/countries/br.m3u</code>
  - Alagoas <code>https://iptv-org.github.io/iptv/subdivisions/br-al.m3u</code>
    - Maceió <code>https://iptv-org.github.io/iptv/cities/brmcz.m3u</code>
  - Amazonas <code>https://iptv-org.github.io/iptv/subdivisions/br-am.m3u</code>
  - Bahia <code>https://iptv-org.github.io/iptv/subdivisions/br-ba.m3u</code>
  - Ceara <code>https://iptv-org.github.io/iptv/subdivisions/br-ce.m3u</code>
  - Distrito Federal <code>https://iptv-org.github.io/iptv/subdivisions/br-df.m3u</code>
    - Brasília <code>https://iptv-org.github.io/iptv/cities/brbsb.m3u</code>
  - Espirito Santo <code>https://iptv-org.github.io/iptv/subdivisions/br-es.m3u</code>
    - Cachoeiro de Itapemirim <code>https://iptv-org.github.io/iptv/cities/brcdi.m3u</code>
    - Colatina <code>https://iptv-org.github.io/iptv/cities/brctn.m3u</code>
    - São Mateus <code>https://iptv-org.github.io/iptv/cities/brsms.m3u</code>
  - Goias <code>https://iptv-org.github.io/iptv/subdivisions/br-go.m3u</code>
    - Caldas Novas <code>https://iptv-org.github.io/iptv/cities/brclv.m3u</code>
  - Maranhao <code>https://iptv-org.github.io/iptv/subdivisions/br-ma.m3u</code>
    - Caxias <code>https://iptv-org.github.io/iptv/cities/brcxs.m3u</code>
  - Mato Grosso <code>https://iptv-org.github.io/iptv/subdivisions/br-mt.m3u</code>
    - Cuiabá <code>https://iptv-org.github.io/iptv/cities/brcba.m3u</code>
    - Tangará da Serra <code>https://iptv-org.github.io/iptv/cities/brtse.m3u</code>
  - Minas Gerais <code>https://iptv-org.github.io/iptv/subdivisions/br-mg.m3u</code>
    - Poços de Caldas <code>https://iptv-org.github.io/iptv/cities/brpoo.m3u</code>
    - São Sebastião do Paraíso <code>https://iptv-org.github.io/iptv/cities/brssp.m3u</code>
    - Uberlândia <code>https://iptv-org.github.io/iptv/cities/brudi.m3u</code>
    - Viçosa <code>https://iptv-org.github.io/iptv/cities/brvis.m3u</code>
  - Para <code>https://iptv-org.github.io/iptv/subdivisions/br-pa.m3u</code>
    - Castanhal <code>https://iptv-org.github.io/iptv/cities/brcas.m3u</code>
  - Paraiba <code>https://iptv-org.github.io/iptv/subdivisions/br-pb.m3u</code>
    - João Pessoa <code>https://iptv-org.github.io/iptv/cities/brjpa.m3u</code>
  - Parana <code>https://iptv-org.github.io/iptv/subdivisions/br-pr.m3u</code>
    - Curitiba <code>https://iptv-org.github.io/iptv/cities/brcwb.m3u</code>
  - Pernambuco <code>https://iptv-org.github.io/iptv/subdivisions/br-pe.m3u</code>
    - Surubim <code>https://iptv-org.github.io/iptv/cities/brsrb.m3u</code>
  - Rio de Janeiro <code>https://iptv-org.github.io/iptv/subdivisions/br-rj.m3u</code>
    - Cabo Frio <code>https://iptv-org.github.io/iptv/cities/brcfo.m3u</code>
    - Maricá <code>https://iptv-org.github.io/iptv/cities/brmrc.m3u</code>
    - Nova Friburgo <code>https://iptv-org.github.io/iptv/cities/brnfu.m3u</code>
  - Rio Grande do Norte <code>https://iptv-org.github.io/iptv/subdivisions/br-rn.m3u</code>
    - Natal <code>https://iptv-org.github.io/iptv/cities/brnat.m3u</code>
  - Rio Grande do Sul <code>https://iptv-org.github.io/iptv/subdivisions/br-rs.m3u</code>
    - Passo Fundo <code>https://iptv-org.github.io/iptv/cities/brpfo.m3u</code>
    - Porto Alegre <code>https://iptv-org.github.io/iptv/cities/brpoa.m3u</code>
  - Rondonia <code>https://iptv-org.github.io/iptv/subdivisions/br-ro.m3u</code>
  - Santa Catarina <code>https://iptv-org.github.io/iptv/subdivisions/br-sc.m3u</code>
    - Balneário Camboriú <code>https://iptv-org.github.io/iptv/cities/brbac.m3u</code>
    - Joinville <code>https://iptv-org.github.io/iptv/cities/brjoi.m3u</code>
    - São José <code>https://iptv-org.github.io/iptv/cities/brsje.m3u</code>
  - Sao Paulo <code>https://iptv-org.github.io/iptv/subdivisions/br-sp.m3u</code>
    - Araçatuba <code>https://iptv-org.github.io/iptv/cities/braru.m3u</code>
    - Guarulhos <code>https://iptv-org.github.io/iptv/cities/brgus.m3u</code>
    - Itapetininga <code>https://iptv-org.github.io/iptv/cities/briig.m3u</code>
    - Jundiaí <code>https://iptv-org.github.io/iptv/cities/brjun.m3u</code>
    - Santos <code>https://iptv-org.github.io/iptv/cities/brssz.m3u</code>
    - Sao Paulo <code>https://iptv-org.github.io/iptv/cities/brsao.m3u</code>
    - Sertãozinho <code>https://iptv-org.github.io/iptv/cities/brszo.m3u</code>
- 🇻🇬 British Virgin Islands <code>https://iptv-org.github.io/iptv/countries/vg.m3u</code>
- 🇧🇳 Brunei <code>https://iptv-org.github.io/iptv/countries/bn.m3u</code>
- 🇧🇬 Bulgaria <code>https://iptv-org.github.io/iptv/countries/bg.m3u</code>
- 🇧🇫 Burkina Faso <code>https://iptv-org.github.io/iptv/countries/bf.m3u</code>
- 🇧🇮 Burundi <code>https://iptv-org.github.io/iptv/countries/bi.m3u</code>
- 🇰🇭 Cambodia <code>https://iptv-org.github.io/iptv/countries/kh.m3u</code>
- 🇨🇲 Cameroon <code>https://iptv-org.github.io/iptv/countries/cm.m3u</code>
- 🇨🇦 Canada <code>https://iptv-org.github.io/iptv/countries/ca.m3u</code>
  - Alberta <code>https://iptv-org.github.io/iptv/subdivisions/ca-ab.m3u</code>
    - Calgary <code>https://iptv-org.github.io/iptv/cities/cacal.m3u</code>
    - Edmonton <code>https://iptv-org.github.io/iptv/cities/caedm.m3u</code>
  - British Columbia <code>https://iptv-org.github.io/iptv/subdivisions/ca-bc.m3u</code>
    - Langley <code>https://iptv-org.github.io/iptv/cities/calng.m3u</code>
    - Vancouver <code>https://iptv-org.github.io/iptv/cities/cavan.m3u</code>
    - Victoria <code>https://iptv-org.github.io/iptv/cities/cavic.m3u</code>
  - Manitoba <code>https://iptv-org.github.io/iptv/subdivisions/ca-mb.m3u</code>
    - Neepawa <code>https://iptv-org.github.io/iptv/cities/canee.m3u</code>
    - Winnipeg <code>https://iptv-org.github.io/iptv/cities/cawnp.m3u</code>
  - New Brunswick <code>https://iptv-org.github.io/iptv/subdivisions/ca-nb.m3u</code>
    - Fredericton <code>https://iptv-org.github.io/iptv/cities/cafre.m3u</code>
    - Moncton <code>https://iptv-org.github.io/iptv/cities/camnt.m3u</code>
  - Newfoundland and Labrador <code>https://iptv-org.github.io/iptv/subdivisions/ca-nl.m3u</code>
    - St. John's <code>https://iptv-org.github.io/iptv/cities/casjf.m3u</code>
  - Northwest Territories <code>https://iptv-org.github.io/iptv/subdivisions/ca-nt.m3u</code>
    - Yellowknife <code>https://iptv-org.github.io/iptv/cities/cayzf.m3u</code>
  - Nova Scotia <code>https://iptv-org.github.io/iptv/subdivisions/ca-ns.m3u</code>
    - Halifax <code>https://iptv-org.github.io/iptv/cities/cahal.m3u</code>
  - Nunavut <code>https://iptv-org.github.io/iptv/subdivisions/ca-nu.m3u</code>
    - Iqaluit <code>https://iptv-org.github.io/iptv/cities/caiql.m3u</code>
  - Ontario <code>https://iptv-org.github.io/iptv/subdivisions/ca-on.m3u</code>
    - Ottawa <code>https://iptv-org.github.io/iptv/cities/caott.m3u</code>
    - Toronto <code>https://iptv-org.github.io/iptv/cities/cator.m3u</code>
    - Windsor <code>https://iptv-org.github.io/iptv/cities/cawnd.m3u</code>
  - Prince Edward Island <code>https://iptv-org.github.io/iptv/subdivisions/ca-pe.m3u</code>
    - Charlottetown <code>https://iptv-org.github.io/iptv/cities/cacha.m3u</code>
  - Quebec <code>https://iptv-org.github.io/iptv/subdivisions/ca-qc.m3u</code>
    - Montréal <code>https://iptv-org.github.io/iptv/cities/camtr.m3u</code>
    - Québec <code>https://iptv-org.github.io/iptv/cities/caque.m3u</code>
    - Rimouski <code>https://iptv-org.github.io/iptv/cities/carim.m3u</code>
    - Saguenay <code>https://iptv-org.github.io/iptv/cities/casag.m3u</code>
    - Sherbrooke <code>https://iptv-org.github.io/iptv/cities/casbr.m3u</code>
    - Témiscaming <code>https://iptv-org.github.io/iptv/cities/catcg.m3u</code>
    - Trois-Rivières <code>https://iptv-org.github.io/iptv/cities/catrr.m3u</code>
  - Saskatchewan <code>https://iptv-org.github.io/iptv/subdivisions/ca-sk.m3u</code>
    - Regina <code>https://iptv-org.github.io/iptv/cities/careg.m3u</code>
- 🇨🇻 Cape Verde <code>https://iptv-org.github.io/iptv/countries/cv.m3u</code>
- 🇨🇫 Central African Republic <code>https://iptv-org.github.io/iptv/countries/cf.m3u</code>
- 🇹🇩 Chad <code>https://iptv-org.github.io/iptv/countries/td.m3u</code>
- 🇨🇱 Chile <code>https://iptv-org.github.io/iptv/countries/cl.m3u</code>
  - Biobio <code>https://iptv-org.github.io/iptv/subdivisions/cl-bi.m3u</code>
    - Yumbel <code>https://iptv-org.github.io/iptv/cities/clyum.m3u</code>
  - La Araucania <code>https://iptv-org.github.io/iptv/subdivisions/cl-ar.m3u</code>
  - Libertador General Bernardo O'Higgins <code>https://iptv-org.github.io/iptv/subdivisions/cl-li.m3u</code>
    - Pichilemu <code>https://iptv-org.github.io/iptv/cities/clplm.m3u</code>
  - Nuble <code>https://iptv-org.github.io/iptv/subdivisions/cl-nb.m3u</code>
- 🇨🇳 China <code>https://iptv-org.github.io/iptv/countries/cn.m3u</code>
- 🇨🇴 Colombia <code>https://iptv-org.github.io/iptv/countries/co.m3u</code>
  - Antioquia <code>https://iptv-org.github.io/iptv/subdivisions/co-ant.m3u</code>
  - Atlantico <code>https://iptv-org.github.io/iptv/subdivisions/co-atl.m3u</code>
    - Barranquilla <code>https://iptv-org.github.io/iptv/cities/cobaq.m3u</code>
  - Bolivar <code>https://iptv-org.github.io/iptv/subdivisions/co-bol.m3u</code>
    - San Jacinto <code>https://iptv-org.github.io/iptv/cities/cosjc.m3u</code>
  - Caldas <code>https://iptv-org.github.io/iptv/subdivisions/co-cal.m3u</code>
    - Manizales <code>https://iptv-org.github.io/iptv/cities/comzl.m3u</code>
  - Cauca <code>https://iptv-org.github.io/iptv/subdivisions/co-cau.m3u</code>
  - Choco <code>https://iptv-org.github.io/iptv/subdivisions/co-cho.m3u</code>
  - Huila <code>https://iptv-org.github.io/iptv/subdivisions/co-hui.m3u</code>
    - Neiva <code>https://iptv-org.github.io/iptv/cities/conva.m3u</code>
  - Narino <code>https://iptv-org.github.io/iptv/subdivisions/co-nar.m3u</code>
    - Pasto <code>https://iptv-org.github.io/iptv/cities/copso.m3u</code>
  - San Andres <code>https://iptv-org.github.io/iptv/subdivisions/co-sap.m3u</code>
    - San Andrés <code>https://iptv-org.github.io/iptv/cities/cosac.m3u</code>
  - Valle del Cauca <code>https://iptv-org.github.io/iptv/subdivisions/co-vac.m3u</code>
    - Cali <code>https://iptv-org.github.io/iptv/cities/coclo.m3u</code>
- 🇰🇲 Comoros <code>https://iptv-org.github.io/iptv/countries/km.m3u</code>
- 🇨🇷 Costa Rica <code>https://iptv-org.github.io/iptv/countries/cr.m3u</code>
  - Cartago <code>https://iptv-org.github.io/iptv/subdivisions/cr-c.m3u</code>
  - Puntarenas <code>https://iptv-org.github.io/iptv/subdivisions/cr-p.m3u</code>
    - San Vito <code>https://iptv-org.github.io/iptv/cities/crtoo.m3u</code>
  - San Jose <code>https://iptv-org.github.io/iptv/subdivisions/cr-sj.m3u</code>
    - San Marcos de Tarrazú <code>https://iptv-org.github.io/iptv/cities/crmtz.m3u</code>
- 🇭🇷 Croatia <code>https://iptv-org.github.io/iptv/countries/hr.m3u</code>
- 🇨🇺 Cuba <code>https://iptv-org.github.io/iptv/countries/cu.m3u</code>
- 🇨🇼 Curacao <code>https://iptv-org.github.io/iptv/countries/cw.m3u</code>
- 🇨🇾 Cyprus <code>https://iptv-org.github.io/iptv/countries/cy.m3u</code>
- 🇨🇿 Czech Republic <code>https://iptv-org.github.io/iptv/countries/cz.m3u</code>
- 🇨🇩 Democratic Republic of the Congo <code>https://iptv-org.github.io/iptv/countries/cd.m3u</code>
- 🇩🇰 Denmark <code>https://iptv-org.github.io/iptv/countries/dk.m3u</code>
- 🇩🇯 Djibouti <code>https://iptv-org.github.io/iptv/countries/dj.m3u</code>
- 🇩🇴 Dominican Republic <code>https://iptv-org.github.io/iptv/countries/do.m3u</code>
  - Cibao Noroeste <code>https://iptv-org.github.io/iptv/subdivisions/do-34.m3u</code>
  - Cibao Norte <code>https://iptv-org.github.io/iptv/subdivisions/do-35.m3u</code>
  - Cibao Sur <code>https://iptv-org.github.io/iptv/subdivisions/do-36.m3u</code>
  - Distrito Nacional <code>https://iptv-org.github.io/iptv/subdivisions/do-01.m3u</code>
  - El Seibo <code>https://iptv-org.github.io/iptv/subdivisions/do-08.m3u</code>
  - El Valle <code>https://iptv-org.github.io/iptv/subdivisions/do-37.m3u</code>
  - La Altagracia <code>https://iptv-org.github.io/iptv/subdivisions/do-11.m3u</code>
    - Higuey <code>https://iptv-org.github.io/iptv/cities/dohig.m3u</code>
  - La Vega <code>https://iptv-org.github.io/iptv/subdivisions/do-13.m3u</code>
    - Constanza <code>https://iptv-org.github.io/iptv/cities/dolvc.m3u</code>
  - Monseñor Nouel <code>https://iptv-org.github.io/iptv/subdivisions/do-28.m3u</code>
    - Bonao <code>https://iptv-org.github.io/iptv/cities/dobno.m3u</code>
  - Ozama <code>https://iptv-org.github.io/iptv/subdivisions/do-40.m3u</code>
  - Puerto Plata <code>https://iptv-org.github.io/iptv/subdivisions/do-18.m3u</code>
    - Puerto Plata <code>https://iptv-org.github.io/iptv/cities/dopop.m3u</code>
  - San Juan <code>https://iptv-org.github.io/iptv/subdivisions/do-22.m3u</code>
  - Santiago <code>https://iptv-org.github.io/iptv/subdivisions/do-25.m3u</code>
    - Santiago de los Caballeros <code>https://iptv-org.github.io/iptv/cities/dosti.m3u</code>
  - Valverde <code>https://iptv-org.github.io/iptv/subdivisions/do-27.m3u</code>
  - Yuma <code>https://iptv-org.github.io/iptv/subdivisions/do-42.m3u</code>
- 🇪🇨 Ecuador <code>https://iptv-org.github.io/iptv/countries/ec.m3u</code>
  - Azuay <code>https://iptv-org.github.io/iptv/subdivisions/ec-a.m3u</code>
    - Cuenca <code>https://iptv-org.github.io/iptv/cities/eccue.m3u</code>
  - Loja <code>https://iptv-org.github.io/iptv/subdivisions/ec-l.m3u</code>
    - Loja <code>https://iptv-org.github.io/iptv/cities/ecloh.m3u</code>
- 🇪🇬 Egypt <code>https://iptv-org.github.io/iptv/countries/eg.m3u</code>
- 🇸🇻 El Salvador <code>https://iptv-org.github.io/iptv/countries/sv.m3u</code>
- 🇬🇶 Equatorial Guinea <code>https://iptv-org.github.io/iptv/countries/gq.m3u</code>
- 🇪🇷 Eritrea <code>https://iptv-org.github.io/iptv/countries/er.m3u</code>
- 🇪🇪 Estonia <code>https://iptv-org.github.io/iptv/countries/ee.m3u</code>
- 🇪🇹 Ethiopia <code>https://iptv-org.github.io/iptv/countries/et.m3u</code>
- 🇫🇴 Faroe Islands <code>https://iptv-org.github.io/iptv/countries/fo.m3u</code>
- 🇫🇮 Finland <code>https://iptv-org.github.io/iptv/countries/fi.m3u</code>
  - Keski-Suomi <code>https://iptv-org.github.io/iptv/subdivisions/fi-08.m3u</code>
    - Kyyjärvi <code>https://iptv-org.github.io/iptv/cities/fikyy.m3u</code>
  - Pohjanmaa <code>https://iptv-org.github.io/iptv/subdivisions/fi-12.m3u</code>
- 🇫🇷 France <code>https://iptv-org.github.io/iptv/countries/fr.m3u</code>
  - Alsace <code>https://iptv-org.github.io/iptv/subdivisions/fr-6ae.m3u</code>
  - Grand-Est <code>https://iptv-org.github.io/iptv/subdivisions/fr-ges.m3u</code>
- 🇵🇫 French Polynesia <code>https://iptv-org.github.io/iptv/countries/pf.m3u</code>
- 🇬🇦 Gabon <code>https://iptv-org.github.io/iptv/countries/ga.m3u</code>
- 🇬🇲 Gambia <code>https://iptv-org.github.io/iptv/countries/gm.m3u</code>
- 🇬🇪 Georgia <code>https://iptv-org.github.io/iptv/countries/ge.m3u</code>
  - Abkhazia <code>https://iptv-org.github.io/iptv/subdivisions/ge-ab.m3u</code>
- 🇩🇪 Germany <code>https://iptv-org.github.io/iptv/countries/de.m3u</code>
  - Bayern <code>https://iptv-org.github.io/iptv/subdivisions/de-by.m3u</code>
  - Berlin <code>https://iptv-org.github.io/iptv/subdivisions/de-be.m3u</code>
  - Brandenburg <code>https://iptv-org.github.io/iptv/subdivisions/de-bb.m3u</code>
  - Hamburg <code>https://iptv-org.github.io/iptv/subdivisions/de-hh.m3u</code>
  - Mecklenburg-Vorpommern <code>https://iptv-org.github.io/iptv/subdivisions/de-mv.m3u</code>
  - Niedersachsen <code>https://iptv-org.github.io/iptv/subdivisions/de-ni.m3u</code>
  - Nordrhein-Westfalen <code>https://iptv-org.github.io/iptv/subdivisions/de-nw.m3u</code>
  - Sachsen <code>https://iptv-org.github.io/iptv/subdivisions/de-sn.m3u</code>
  - Sachsen-Anhalt <code>https://iptv-org.github.io/iptv/subdivisions/de-st.m3u</code>
  - Schleswig-Holstein <code>https://iptv-org.github.io/iptv/subdivisions/de-sh.m3u</code>
  - Thüringen <code>https://iptv-org.github.io/iptv/subdivisions/de-th.m3u</code>
- 🇬🇭 Ghana <code>https://iptv-org.github.io/iptv/countries/gh.m3u</code>
- 🇬🇷 Greece <code>https://iptv-org.github.io/iptv/countries/gr.m3u</code>
  - Attiki <code>https://iptv-org.github.io/iptv/subdivisions/gr-i.m3u</code>
    - Athens <code>https://iptv-org.github.io/iptv/cities/grath.m3u</code>
  - Dytiki Ellada <code>https://iptv-org.github.io/iptv/subdivisions/gr-g.m3u</code>
  - Dytiki Makedonia <code>https://iptv-org.github.io/iptv/subdivisions/gr-c.m3u</code>
    - Kozáni <code>https://iptv-org.github.io/iptv/cities/grkzi.m3u</code>
  - Ionia Nisia <code>https://iptv-org.github.io/iptv/subdivisions/gr-f.m3u</code>
  - Ipeiros <code>https://iptv-org.github.io/iptv/subdivisions/gr-d.m3u</code>
    - Árta <code>https://iptv-org.github.io/iptv/cities/grart.m3u</code>
    - Ioánnina <code>https://iptv-org.github.io/iptv/cities/grioa.m3u</code>
  - Kentriki Makedonia <code>https://iptv-org.github.io/iptv/subdivisions/gr-b.m3u</code>
    - Giannitsá <code>https://iptv-org.github.io/iptv/cities/grgak.m3u</code>
    - Thessaloníki <code>https://iptv-org.github.io/iptv/cities/grskg.m3u</code>
  - Notio Aigaio <code>https://iptv-org.github.io/iptv/subdivisions/gr-l.m3u</code>
  - Sterea Ellada <code>https://iptv-org.github.io/iptv/subdivisions/gr-h.m3u</code>
    - Lamía <code>https://iptv-org.github.io/iptv/cities/grlam.m3u</code>
  - Thessalia <code>https://iptv-org.github.io/iptv/subdivisions/gr-e.m3u</code>
    - Lárisa <code>https://iptv-org.github.io/iptv/cities/grlra.m3u</code>
- 🇬🇵 Guadeloupe <code>https://iptv-org.github.io/iptv/countries/gp.m3u</code>
- 🇬🇺 Guam <code>https://iptv-org.github.io/iptv/countries/gu.m3u</code>
- 🇬🇹 Guatemala <code>https://iptv-org.github.io/iptv/countries/gt.m3u</code>
  - Escuintla <code>https://iptv-org.github.io/iptv/subdivisions/gt-05.m3u</code>
  - Huehuetenango <code>https://iptv-org.github.io/iptv/subdivisions/gt-13.m3u</code>
  - Izabal <code>https://iptv-org.github.io/iptv/subdivisions/gt-18.m3u</code>
    - Puerto Barrios <code>https://iptv-org.github.io/iptv/cities/gtpbr.m3u</code>
  - Quiche <code>https://iptv-org.github.io/iptv/subdivisions/gt-14.m3u</code>
  - Sacatepequez <code>https://iptv-org.github.io/iptv/subdivisions/gt-03.m3u</code>
  - San Marcos <code>https://iptv-org.github.io/iptv/subdivisions/gt-12.m3u</code>
  - Santa Rosa <code>https://iptv-org.github.io/iptv/subdivisions/gt-06.m3u</code>
    - Barberena <code>https://iptv-org.github.io/iptv/cities/gtbab.m3u</code>
  - Solola <code>https://iptv-org.github.io/iptv/subdivisions/gt-07.m3u</code>
    - Sololá <code>https://iptv-org.github.io/iptv/cities/gtsol.m3u</code>
  - Totonicapan <code>https://iptv-org.github.io/iptv/subdivisions/gt-08.m3u</code>
- 🇬🇬 Guernsey <code>https://iptv-org.github.io/iptv/countries/gg.m3u</code>
- 🇬🇳 Guinea <code>https://iptv-org.github.io/iptv/countries/gn.m3u</code>
- 🇬🇾 Guyana <code>https://iptv-org.github.io/iptv/countries/gy.m3u</code>
- 🇭🇹 Haiti <code>https://iptv-org.github.io/iptv/countries/ht.m3u</code>
- 🇭🇳 Honduras <code>https://iptv-org.github.io/iptv/countries/hn.m3u</code>
- 🇭🇰 Hong Kong <code>https://iptv-org.github.io/iptv/countries/hk.m3u</code>
- 🇭🇺 Hungary <code>https://iptv-org.github.io/iptv/countries/hu.m3u</code>
- 🇮🇸 Iceland <code>https://iptv-org.github.io/iptv/countries/is.m3u</code>
- 🇮🇳 India <code>https://iptv-org.github.io/iptv/countries/in.m3u</code>
  - Andhra Pradesh <code>https://iptv-org.github.io/iptv/subdivisions/in-ap.m3u</code>
  - Karnataka <code>https://iptv-org.github.io/iptv/subdivisions/in-ka.m3u</code>
- 🇮🇩 Indonesia <code>https://iptv-org.github.io/iptv/countries/id.m3u</code>
  - Aceh <code>https://iptv-org.github.io/iptv/subdivisions/id-ac.m3u</code>
  - Bali <code>https://iptv-org.github.io/iptv/subdivisions/id-ba.m3u</code>
  - Bengkulu <code>https://iptv-org.github.io/iptv/subdivisions/id-be.m3u</code>
  - Bengkulu <code>https://iptv-org.github.io/iptv/subdivisions/id-bt.m3u</code>
    - Serang <code>https://iptv-org.github.io/iptv/cities/idser.m3u</code>
  - Gorontalo <code>https://iptv-org.github.io/iptv/subdivisions/id-go.m3u</code>
  - Jakarta Raya <code>https://iptv-org.github.io/iptv/subdivisions/id-jk.m3u</code>
    - Jakarta <code>https://iptv-org.github.io/iptv/cities/idjkt.m3u</code>
  - Jambi <code>https://iptv-org.github.io/iptv/subdivisions/id-ja.m3u</code>
  - Jawa <code>https://iptv-org.github.io/iptv/subdivisions/id-jw.m3u</code>
  - Jawa Barat <code>https://iptv-org.github.io/iptv/subdivisions/id-jb.m3u</code>
    - Sumedang <code>https://iptv-org.github.io/iptv/cities/id5su.m3u</code>
    - Tasikmalaya <code>https://iptv-org.github.io/iptv/cities/idtsy.m3u</code>
  - Jawa Tengah <code>https://iptv-org.github.io/iptv/subdivisions/id-jt.m3u</code>
    - Purwokerto <code>https://iptv-org.github.io/iptv/cities/idpwl.m3u</code>
    - Semarang <code>https://iptv-org.github.io/iptv/cities/idsrg.m3u</code>
    - Surakarta <code>https://iptv-org.github.io/iptv/cities/idskt.m3u</code>
  - Jawa Timur <code>https://iptv-org.github.io/iptv/subdivisions/id-ji.m3u</code>
    - Kediri <code>https://iptv-org.github.io/iptv/cities/idkdr.m3u</code>
    - Madiun <code>https://iptv-org.github.io/iptv/cities/idmdi.m3u</code>
    - Malang <code>https://iptv-org.github.io/iptv/cities/idmlg.m3u</code>
    - Surabaya <code>https://iptv-org.github.io/iptv/cities/idsub.m3u</code>
    - Tulungagung <code>https://iptv-org.github.io/iptv/cities/idtlu.m3u</code>
  - Kalimantan <code>https://iptv-org.github.io/iptv/subdivisions/id-ka.m3u</code>
  - Kalimantan Barat <code>https://iptv-org.github.io/iptv/subdivisions/id-kb.m3u</code>
  - Kalimantan Selatan <code>https://iptv-org.github.io/iptv/subdivisions/id-ks.m3u</code>
    - Banjarmasin <code>https://iptv-org.github.io/iptv/cities/idbdj.m3u</code>
  - Kalimantan Tengah <code>https://iptv-org.github.io/iptv/subdivisions/id-kt.m3u</code>
  - Kalimantan Timur <code>https://iptv-org.github.io/iptv/subdivisions/id-ki.m3u</code>
    - Balikpapan <code>https://iptv-org.github.io/iptv/cities/idbpn.m3u</code>
  - Kepulauan Bangka Belitung <code>https://iptv-org.github.io/iptv/subdivisions/id-bb.m3u</code>
  - Lampung <code>https://iptv-org.github.io/iptv/subdivisions/id-la.m3u</code>
    - Bandar Lampung <code>https://iptv-org.github.io/iptv/cities/idtkg.m3u</code>
  - Maluku <code>https://iptv-org.github.io/iptv/subdivisions/id-ml.m3u</code>
  - Maluku Utara <code>https://iptv-org.github.io/iptv/subdivisions/id-mu.m3u</code>
  - Nusa Tenggara <code>https://iptv-org.github.io/iptv/subdivisions/id-nu.m3u</code>
  - Nusa Tenggara Barat <code>https://iptv-org.github.io/iptv/subdivisions/id-nb.m3u</code>
  - Nusa Tenggara Timur <code>https://iptv-org.github.io/iptv/subdivisions/id-nt.m3u</code>
    - Atambua <code>https://iptv-org.github.io/iptv/cities/idabu.m3u</code>
  - Papua <code>https://iptv-org.github.io/iptv/subdivisions/id-pp.m3u</code>
  - Papua Barat <code>https://iptv-org.github.io/iptv/subdivisions/id-pb.m3u</code>
  - Riau <code>https://iptv-org.github.io/iptv/subdivisions/id-ri.m3u</code>
  - Sulawesi <code>https://iptv-org.github.io/iptv/subdivisions/id-sl.m3u</code>
  - Sulawesi Barat <code>https://iptv-org.github.io/iptv/subdivisions/id-sr.m3u</code>
  - Sulawesi Selatan <code>https://iptv-org.github.io/iptv/subdivisions/id-sn.m3u</code>
    - Makassar <code>https://iptv-org.github.io/iptv/cities/idmak.m3u</code>
  - Sulawesi Tengah <code>https://iptv-org.github.io/iptv/subdivisions/id-st.m3u</code>
  - Sulawesi Tenggara <code>https://iptv-org.github.io/iptv/subdivisions/id-sg.m3u</code>
  - Sulawesi Utara <code>https://iptv-org.github.io/iptv/subdivisions/id-sa.m3u</code>
    - Manado <code>https://iptv-org.github.io/iptv/cities/idmdc.m3u</code>
  - Sumatera <code>https://iptv-org.github.io/iptv/subdivisions/id-sm.m3u</code>
  - Sumatera Barat <code>https://iptv-org.github.io/iptv/subdivisions/id-sb.m3u</code>
    - Padang <code>https://iptv-org.github.io/iptv/cities/idpdg.m3u</code>
  - Sumatera Selatan <code>https://iptv-org.github.io/iptv/subdivisions/id-ss.m3u</code>
  - Sumatera Utara <code>https://iptv-org.github.io/iptv/subdivisions/id-su.m3u</code>
  - Yogyakarta <code>https://iptv-org.github.io/iptv/subdivisions/id-yo.m3u</code>
    - Yogyakarta <code>https://iptv-org.github.io/iptv/cities/idjog.m3u</code>
- 🇮🇷 Iran <code>https://iptv-org.github.io/iptv/countries/ir.m3u</code>
- 🇮🇶 Iraq <code>https://iptv-org.github.io/iptv/countries/iq.m3u</code>
- 🇮🇪 Ireland <code>https://iptv-org.github.io/iptv/countries/ie.m3u</code>
- 🇮🇱 Israel <code>https://iptv-org.github.io/iptv/countries/il.m3u</code>
- 🇮🇹 Italy <code>https://iptv-org.github.io/iptv/countries/it.m3u</code>
  - Calabria <code>https://iptv-org.github.io/iptv/subdivisions/it-78.m3u</code>
  - Trentino-Alto Adige <code>https://iptv-org.github.io/iptv/subdivisions/it-32.m3u</code>
- 🇨🇮 Ivory Coast <code>https://iptv-org.github.io/iptv/countries/ci.m3u</code>
- 🇯🇲 Jamaica <code>https://iptv-org.github.io/iptv/countries/jm.m3u</code>
- 🇯🇵 Japan <code>https://iptv-org.github.io/iptv/countries/jp.m3u</code>
  - Chiba <code>https://iptv-org.github.io/iptv/subdivisions/jp-12.m3u</code>
  - Gunma <code>https://iptv-org.github.io/iptv/subdivisions/jp-10.m3u</code>
  - Ibaraki <code>https://iptv-org.github.io/iptv/subdivisions/jp-08.m3u</code>
  - Kanagawa <code>https://iptv-org.github.io/iptv/subdivisions/jp-14.m3u</code>
  - Saitama <code>https://iptv-org.github.io/iptv/subdivisions/jp-11.m3u</code>
  - Tochigi <code>https://iptv-org.github.io/iptv/subdivisions/jp-09.m3u</code>
  - Tokyo <code>https://iptv-org.github.io/iptv/subdivisions/jp-13.m3u</code>
    - Tokyo <code>https://iptv-org.github.io/iptv/cities/jptyo.m3u</code>
- 🇯🇴 Jordan <code>https://iptv-org.github.io/iptv/countries/jo.m3u</code>
- 🇰🇿 Kazakhstan <code>https://iptv-org.github.io/iptv/countries/kz.m3u</code>
- 🇰🇪 Kenya <code>https://iptv-org.github.io/iptv/countries/ke.m3u</code>
- 🇽🇰 Kosovo <code>https://iptv-org.github.io/iptv/countries/xk.m3u</code>
- 🇰🇼 Kuwait <code>https://iptv-org.github.io/iptv/countries/kw.m3u</code>
- 🇰🇬 Kyrgyzstan <code>https://iptv-org.github.io/iptv/countries/kg.m3u</code>
- 🇱🇦 Laos <code>https://iptv-org.github.io/iptv/countries/la.m3u</code>
- 🇱🇻 Latvia <code>https://iptv-org.github.io/iptv/countries/lv.m3u</code>
- 🇱🇧 Lebanon <code>https://iptv-org.github.io/iptv/countries/lb.m3u</code>
- 🇱🇷 Liberia <code>https://iptv-org.github.io/iptv/countries/lr.m3u</code>
- 🇱🇾 Libya <code>https://iptv-org.github.io/iptv/countries/ly.m3u</code>
- 🇱🇮 Liechtenstein <code>https://iptv-org.github.io/iptv/countries/li.m3u</code>
- 🇱🇹 Lithuania <code>https://iptv-org.github.io/iptv/countries/lt.m3u</code>
- 🇱🇺 Luxembourg <code>https://iptv-org.github.io/iptv/countries/lu.m3u</code>
- 🇲🇴 Macao <code>https://iptv-org.github.io/iptv/countries/mo.m3u</code>
- 🇲🇬 Madagascar <code>https://iptv-org.github.io/iptv/countries/mg.m3u</code>
- 🇲🇼 Malawi <code>https://iptv-org.github.io/iptv/countries/mw.m3u</code>
- 🇲🇾 Malaysia <code>https://iptv-org.github.io/iptv/countries/my.m3u</code>
- 🇲🇻 Maldives <code>https://iptv-org.github.io/iptv/countries/mv.m3u</code>
- 🇲🇱 Mali <code>https://iptv-org.github.io/iptv/countries/ml.m3u</code>
- 🇲🇹 Malta <code>https://iptv-org.github.io/iptv/countries/mt.m3u</code>
- 🇲🇶 Martinique <code>https://iptv-org.github.io/iptv/countries/mq.m3u</code>
- 🇲🇷 Mauritania <code>https://iptv-org.github.io/iptv/countries/mr.m3u</code>
  - West Nouakchott <code>https://iptv-org.github.io/iptv/subdivisions/mr-13.m3u</code>
- 🇲🇺 Mauritius <code>https://iptv-org.github.io/iptv/countries/mu.m3u</code>
- 🇲🇽 Mexico <code>https://iptv-org.github.io/iptv/countries/mx.m3u</code>
  - Baja California <code>https://iptv-org.github.io/iptv/subdivisions/mx-bcn.m3u</code>
    - Tijuana <code>https://iptv-org.github.io/iptv/cities/mxtij.m3u</code>
  - Chihuahua <code>https://iptv-org.github.io/iptv/subdivisions/mx-chh.m3u</code>
    - Ciudad Juárez <code>https://iptv-org.github.io/iptv/cities/mxcjs.m3u</code>
  - Coahuila de Zaragoza <code>https://iptv-org.github.io/iptv/subdivisions/mx-coa.m3u</code>
    - Sabinas <code>https://iptv-org.github.io/iptv/cities/mxsbn.m3u</code>
  - Durango <code>https://iptv-org.github.io/iptv/subdivisions/mx-dur.m3u</code>
  - Morelos <code>https://iptv-org.github.io/iptv/subdivisions/mx-mor.m3u</code>
    - Cuernavaca <code>https://iptv-org.github.io/iptv/cities/mxcvc.m3u</code>
  - Nuevo Leon <code>https://iptv-org.github.io/iptv/subdivisions/mx-nle.m3u</code>
  - Puebla <code>https://iptv-org.github.io/iptv/subdivisions/mx-pue.m3u</code>
  - Queretaro <code>https://iptv-org.github.io/iptv/subdivisions/mx-que.m3u</code>
    - Santiago de Querétaro <code>https://iptv-org.github.io/iptv/cities/mxsqe.m3u</code>
  - Quintana Roo <code>https://iptv-org.github.io/iptv/subdivisions/mx-roo.m3u</code>
    - Cancún <code>https://iptv-org.github.io/iptv/cities/mxcun.m3u</code>
  - San Luis Potosi <code>https://iptv-org.github.io/iptv/subdivisions/mx-slp.m3u</code>
  - Yucatan <code>https://iptv-org.github.io/iptv/subdivisions/mx-yuc.m3u</code>
    - Mérida <code>https://iptv-org.github.io/iptv/cities/mxmid.m3u</code>
- 🇲🇩 Moldova <code>https://iptv-org.github.io/iptv/countries/md.m3u</code>
- 🇲🇨 Monaco <code>https://iptv-org.github.io/iptv/countries/mc.m3u</code>
- 🇲🇳 Mongolia <code>https://iptv-org.github.io/iptv/countries/mn.m3u</code>
- 🇲🇪 Montenegro <code>https://iptv-org.github.io/iptv/countries/me.m3u</code>
  - Ulcinj <code>https://iptv-org.github.io/iptv/subdivisions/me-20.m3u</code>
    - Ulcinj <code>https://iptv-org.github.io/iptv/cities/meulc.m3u</code>
- 🇲🇦 Morocco <code>https://iptv-org.github.io/iptv/countries/ma.m3u</code>
- 🇲🇿 Mozambique <code>https://iptv-org.github.io/iptv/countries/mz.m3u</code>
- 🇲🇲 Myanmar <code>https://iptv-org.github.io/iptv/countries/mm.m3u</code>
- 🇳🇦 Namibia <code>https://iptv-org.github.io/iptv/countries/na.m3u</code>
- 🇳🇵 Nepal <code>https://iptv-org.github.io/iptv/countries/np.m3u</code>
- 🇳🇱 Netherlands <code>https://iptv-org.github.io/iptv/countries/nl.m3u</code>
- 🇳🇿 New Zealand <code>https://iptv-org.github.io/iptv/countries/nz.m3u</code>
- 🇳🇮 Nicaragua <code>https://iptv-org.github.io/iptv/countries/ni.m3u</code>
- 🇳🇪 Niger <code>https://iptv-org.github.io/iptv/countries/ne.m3u</code>
- 🇳🇬 Nigeria <code>https://iptv-org.github.io/iptv/countries/ng.m3u</code>
- 🇰🇵 North Korea <code>https://iptv-org.github.io/iptv/countries/kp.m3u</code>
- 🇲🇰 North Macedonia <code>https://iptv-org.github.io/iptv/countries/mk.m3u</code>
- 🇳🇴 Norway <code>https://iptv-org.github.io/iptv/countries/no.m3u</code>
- 🇴🇲 Oman <code>https://iptv-org.github.io/iptv/countries/om.m3u</code>
- 🇵🇰 Pakistan <code>https://iptv-org.github.io/iptv/countries/pk.m3u</code>
- 🇵🇸 Palestine <code>https://iptv-org.github.io/iptv/countries/ps.m3u</code>
- 🇵🇦 Panama <code>https://iptv-org.github.io/iptv/countries/pa.m3u</code>
- 🇵🇬 Papua New Guinea <code>https://iptv-org.github.io/iptv/countries/pg.m3u</code>
- 🇵🇾 Paraguay <code>https://iptv-org.github.io/iptv/countries/py.m3u</code>
  - Itapua <code>https://iptv-org.github.io/iptv/subdivisions/py-7.m3u</code>
    - Encarnacion <code>https://iptv-org.github.io/iptv/cities/pyeno.m3u</code>
- 🇵🇪 Peru <code>https://iptv-org.github.io/iptv/countries/pe.m3u</code>
  - Arequipa <code>https://iptv-org.github.io/iptv/subdivisions/pe-are.m3u</code>
    - Arequipa <code>https://iptv-org.github.io/iptv/cities/peaqp.m3u</code>
  - Junin <code>https://iptv-org.github.io/iptv/subdivisions/pe-jun.m3u</code>
    - Huancayo <code>https://iptv-org.github.io/iptv/cities/pejhy.m3u</code>
    - Satipo <code>https://iptv-org.github.io/iptv/cities/pesip.m3u</code>
  - Lima <code>https://iptv-org.github.io/iptv/subdivisions/pe-lim.m3u</code>
    - Lima <code>https://iptv-org.github.io/iptv/cities/pelim.m3u</code>
  - Loreto <code>https://iptv-org.github.io/iptv/subdivisions/pe-lor.m3u</code>
    - Yurimaguas <code>https://iptv-org.github.io/iptv/cities/peyms.m3u</code>
  - San Martin <code>https://iptv-org.github.io/iptv/subdivisions/pe-sam.m3u</code>
- 🇵🇭 Philippines <code>https://iptv-org.github.io/iptv/countries/ph.m3u</code>
- 🇵🇱 Poland <code>https://iptv-org.github.io/iptv/countries/pl.m3u</code>
- 🇵🇹 Portugal <code>https://iptv-org.github.io/iptv/countries/pt.m3u</code>
- 🇵🇷 Puerto Rico <code>https://iptv-org.github.io/iptv/countries/pr.m3u</code>
- 🇶🇦 Qatar <code>https://iptv-org.github.io/iptv/countries/qa.m3u</code>
- 🇨🇬 Republic of the Congo <code>https://iptv-org.github.io/iptv/countries/cg.m3u</code>
  - Brazzaville <code>https://iptv-org.github.io/iptv/subdivisions/cg-bzv.m3u</code>
    - Brazzaville <code>https://iptv-org.github.io/iptv/cities/cgbzv.m3u</code>
- 🇷🇪 Reunion <code>https://iptv-org.github.io/iptv/countries/re.m3u</code>
- 🇷🇴 Romania <code>https://iptv-org.github.io/iptv/countries/ro.m3u</code>
- 🇷🇺 Russia <code>https://iptv-org.github.io/iptv/countries/ru.m3u</code>
  - Adygeya, Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-ad.m3u</code>
  - Altay, Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-al.m3u</code>
  - Altayskiy kray <code>https://iptv-org.github.io/iptv/subdivisions/ru-alt.m3u</code>
  - Arkhangel'skaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-ark.m3u</code>
  - Astrakhanskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-ast.m3u</code>
  - Bashkortostan, Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-ba.m3u</code>
  - Belgorodskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-bel.m3u</code>
  - Chechenskaya Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-ce.m3u</code>
  - Chelyabinskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-che.m3u</code>
  - Dagestan, Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-da.m3u</code>
  - Ingushetiya, Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-in.m3u</code>
  - Irkutskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-irk.m3u</code>
  - Kabardino-Balkarskaya Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-kb.m3u</code>
  - Kaliningradskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-kgd.m3u</code>
  - Kaluzhskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-klu.m3u</code>
  - Karachayevo-Cherkesskaya Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-kc.m3u</code>
  - Kemerovskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-kem.m3u</code>
  - Khabarovskiy kray <code>https://iptv-org.github.io/iptv/subdivisions/ru-kha.m3u</code>
  - Khakasiya, Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-kk.m3u</code>
  - Khanty-Mansiyskiy avtonomnyy okrug <code>https://iptv-org.github.io/iptv/subdivisions/ru-khm.m3u</code>
  - Krasnodarskiy kray <code>https://iptv-org.github.io/iptv/subdivisions/ru-kda.m3u</code>
    - Krasnodar <code>https://iptv-org.github.io/iptv/cities/rukrr.m3u</code>
  - Krasnoyarskiy kray <code>https://iptv-org.github.io/iptv/subdivisions/ru-kya.m3u</code>
  - Kurganskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-kgn.m3u</code>
  - Leningradskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-len.m3u</code>
  - Mordoviya, Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-mo.m3u</code>
  - Moskovskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-mos.m3u</code>
  - Moskva <code>https://iptv-org.github.io/iptv/subdivisions/ru-mow.m3u</code>
  - Nenetskiy avtonomnyy okrug <code>https://iptv-org.github.io/iptv/subdivisions/ru-nen.m3u</code>
  - Nizhegorodskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-niz.m3u</code>
  - Novgorodskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-ngr.m3u</code>
  - Novosibirskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-nvs.m3u</code>
  - Omskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-oms.m3u</code>
  - Orenburgskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-ore.m3u</code>
  - Permskiy kray <code>https://iptv-org.github.io/iptv/subdivisions/ru-per.m3u</code>
  - Primorskiy kray <code>https://iptv-org.github.io/iptv/subdivisions/ru-pri.m3u</code>
    - Vladivostok <code>https://iptv-org.github.io/iptv/cities/ruvms.m3u</code>
  - Rostovskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-ros.m3u</code>
  - Ryazanskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-rya.m3u</code>
  - Saha, Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-sa.m3u</code>
  - Samarskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-sam.m3u</code>
  - Sankt-Peterburg <code>https://iptv-org.github.io/iptv/subdivisions/ru-spe.m3u</code>
  - Severnaya Osetiya, Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-se.m3u</code>
  - Stavropol'skiy kray <code>https://iptv-org.github.io/iptv/subdivisions/ru-sta.m3u</code>
  - Sverdlovskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-sve.m3u</code>
  - Tambovskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-tam.m3u</code>
  - Tatarstan, Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-ta.m3u</code>
  - Tomskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-tom.m3u</code>
  - Tyumenskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-tyu.m3u</code>
  - Tyva, Respublika <code>https://iptv-org.github.io/iptv/subdivisions/ru-ty.m3u</code>
  - Volgogradskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-vgg.m3u</code>
  - Yamalo-Nenetskiy avtonomnyy okrug <code>https://iptv-org.github.io/iptv/subdivisions/ru-yan.m3u</code>
  - Yaroslavskaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-yar.m3u</code>
  - Yevreyskaya avtonomnaya oblast' <code>https://iptv-org.github.io/iptv/subdivisions/ru-yev.m3u</code>
- 🇷🇼 Rwanda <code>https://iptv-org.github.io/iptv/countries/rw.m3u</code>
- 🇰🇳 Saint Kitts and Nevis <code>https://iptv-org.github.io/iptv/countries/kn.m3u</code>
- 🇱🇨 Saint Lucia <code>https://iptv-org.github.io/iptv/countries/lc.m3u</code>
- 🇼🇸 Samoa <code>https://iptv-org.github.io/iptv/countries/ws.m3u</code>
- 🇸🇲 San Marino <code>https://iptv-org.github.io/iptv/countries/sm.m3u</code>
- 🇸🇦 Saudi Arabia <code>https://iptv-org.github.io/iptv/countries/sa.m3u</code>
- 🇸🇳 Senegal <code>https://iptv-org.github.io/iptv/countries/sn.m3u</code>
- 🇷🇸 Serbia <code>https://iptv-org.github.io/iptv/countries/rs.m3u</code>
- 🇸🇱 Sierra Leone <code>https://iptv-org.github.io/iptv/countries/sl.m3u</code>
- 🇸🇬 Singapore <code>https://iptv-org.github.io/iptv/countries/sg.m3u</code>
- 🇸🇽 Sint Maarten <code>https://iptv-org.github.io/iptv/countries/sx.m3u</code>
- 🇸🇰 Slovakia <code>https://iptv-org.github.io/iptv/countries/sk.m3u</code>
- 🇸🇮 Slovenia <code>https://iptv-org.github.io/iptv/countries/si.m3u</code>
- 🇸🇴 Somalia <code>https://iptv-org.github.io/iptv/countries/so.m3u</code>
- 🇿🇦 South Africa <code>https://iptv-org.github.io/iptv/countries/za.m3u</code>
- 🇰🇷 South Korea <code>https://iptv-org.github.io/iptv/countries/kr.m3u</code>
  - Busan-gwangyeoksi <code>https://iptv-org.github.io/iptv/subdivisions/kr-26.m3u</code>
    - Busan <code>https://iptv-org.github.io/iptv/cities/krpus.m3u</code>
  - Chungcheongbuk-do <code>https://iptv-org.github.io/iptv/subdivisions/kr-43.m3u</code>
    - Cheongju <code>https://iptv-org.github.io/iptv/cities/krcoj.m3u</code>
  - Daegu-gwangyeoksi <code>https://iptv-org.github.io/iptv/subdivisions/kr-27.m3u</code>
    - Daegu <code>https://iptv-org.github.io/iptv/cities/krtae.m3u</code>
  - Daejeon-gwangyeoksi <code>https://iptv-org.github.io/iptv/subdivisions/kr-30.m3u</code>
    - Daejeon <code>https://iptv-org.github.io/iptv/cities/krtjn.m3u</code>
  - Gangwon-do <code>https://iptv-org.github.io/iptv/subdivisions/kr-42.m3u</code>
    - Chuncheon <code>https://iptv-org.github.io/iptv/cities/krchc.m3u</code>
  - Gyeonggi-do <code>https://iptv-org.github.io/iptv/subdivisions/kr-41.m3u</code>
    - Bucheon <code>https://iptv-org.github.io/iptv/cities/krbcn.m3u</code>
  - Gyeongsangbuk-do <code>https://iptv-org.github.io/iptv/subdivisions/kr-47.m3u</code>
    - Andong <code>https://iptv-org.github.io/iptv/cities/kradg.m3u</code>
  - Gyeongsangnam-do <code>https://iptv-org.github.io/iptv/subdivisions/kr-48.m3u</code>
  - Jeju-teukbyeoljachido <code>https://iptv-org.github.io/iptv/subdivisions/kr-49.m3u</code>
    - Jeju <code>https://iptv-org.github.io/iptv/cities/krcha.m3u</code>
  - Jeollabuk-do <code>https://iptv-org.github.io/iptv/subdivisions/kr-45.m3u</code>
    - Jeonju <code>https://iptv-org.github.io/iptv/cities/krjnj.m3u</code>
  - Jeollanam-do <code>https://iptv-org.github.io/iptv/subdivisions/kr-46.m3u</code>
    - Mokpo <code>https://iptv-org.github.io/iptv/cities/krmok.m3u</code>
    - Yeosu <code>https://iptv-org.github.io/iptv/cities/kryos.m3u</code>
  - Seoul-teukbyeolsi <code>https://iptv-org.github.io/iptv/subdivisions/kr-11.m3u</code>
  - Ulsan-gwangyeoksi <code>https://iptv-org.github.io/iptv/subdivisions/kr-31.m3u</code>
    - Ulsan <code>https://iptv-org.github.io/iptv/cities/krusn.m3u</code>
- 🇪🇸 Spain <code>https://iptv-org.github.io/iptv/countries/es.m3u</code>
  - Andalucía <code>https://iptv-org.github.io/iptv/subdivisions/es-an.m3u</code>
  - Aragón <code>https://iptv-org.github.io/iptv/subdivisions/es-ar.m3u</code>
  - Barcelona <code>https://iptv-org.github.io/iptv/subdivisions/es-b.m3u</code>
    - Cabrils <code>https://iptv-org.github.io/iptv/cities/escbi.m3u</code>
    - Cardedeu <code>https://iptv-org.github.io/iptv/cities/escdd.m3u</code>
    - Mataró <code>https://iptv-org.github.io/iptv/cities/esmto.m3u</code>
    - Sabadell <code>https://iptv-org.github.io/iptv/cities/essbp.m3u</code>
    - Vic <code>https://iptv-org.github.io/iptv/cities/esvic.m3u</code>
  - Bizkaia <code>https://iptv-org.github.io/iptv/subdivisions/es-bi.m3u</code>
    - Bilbao <code>https://iptv-org.github.io/iptv/cities/esbio.m3u</code>
  - Cádiz <code>https://iptv-org.github.io/iptv/subdivisions/es-ca.m3u</code>
    - Algeciras <code>https://iptv-org.github.io/iptv/cities/esalg.m3u</code>
  - Canarias <code>https://iptv-org.github.io/iptv/subdivisions/es-cn.m3u</code>
  - Castilla-La Mancha <code>https://iptv-org.github.io/iptv/subdivisions/es-cm.m3u</code>
  - Catalunya <code>https://iptv-org.github.io/iptv/subdivisions/es-ct.m3u</code>
  - Córdoba <code>https://iptv-org.github.io/iptv/subdivisions/es-co.m3u</code>
    - Córdoba <code>https://iptv-org.github.io/iptv/cities/esodb.m3u</code>
  - Galicia <code>https://iptv-org.github.io/iptv/subdivisions/es-ga.m3u</code>
  - Girona <code>https://iptv-org.github.io/iptv/subdivisions/es-gi.m3u</code>
    - Olot <code>https://iptv-org.github.io/iptv/cities/esooe.m3u</code>
    - Palafrugell <code>https://iptv-org.github.io/iptv/cities/espfl.m3u</code>
  - Granada <code>https://iptv-org.github.io/iptv/subdivisions/es-gr.m3u</code>
    - Granada <code>https://iptv-org.github.io/iptv/cities/esgrx.m3u</code>
  - Huelva <code>https://iptv-org.github.io/iptv/subdivisions/es-h.m3u</code>
    - Huelva <code>https://iptv-org.github.io/iptv/cities/eshuv.m3u</code>
  - Illes Balears <code>https://iptv-org.github.io/iptv/subdivisions/es-ib.m3u</code>
  - Jaén <code>https://iptv-org.github.io/iptv/subdivisions/es-j.m3u</code>
    - Jaén <code>https://iptv-org.github.io/iptv/cities/esjae.m3u</code>
  - La Rioja <code>https://iptv-org.github.io/iptv/subdivisions/es-ri.m3u</code>
    - Logroño <code>https://iptv-org.github.io/iptv/cities/eslgr.m3u</code>
  - Las Palmas <code>https://iptv-org.github.io/iptv/subdivisions/es-gc.m3u</code>
    - Mogán <code>https://iptv-org.github.io/iptv/cities/eszih.m3u</code>
  - Lleida <code>https://iptv-org.github.io/iptv/subdivisions/es-l.m3u</code>
    - La Seu d'Urgell <code>https://iptv-org.github.io/iptv/cities/eslsl.m3u</code>
    - Lleida <code>https://iptv-org.github.io/iptv/cities/eslle.m3u</code>
  - Madrid <code>https://iptv-org.github.io/iptv/subdivisions/es-md.m3u</code>
  - Málaga <code>https://iptv-org.github.io/iptv/subdivisions/es-ma.m3u</code>
    - Fuengirola <code>https://iptv-org.github.io/iptv/cities/esfgl.m3u</code>
    - Marbella <code>https://iptv-org.github.io/iptv/cities/esmqe.m3u</code>
  - Murcia <code>https://iptv-org.github.io/iptv/subdivisions/es-mc.m3u</code>
  - Navarra <code>https://iptv-org.github.io/iptv/subdivisions/es-na.m3u</code>
    - Pamplona <code>https://iptv-org.github.io/iptv/cities/espna.m3u</code>
  - Navarra <code>https://iptv-org.github.io/iptv/subdivisions/es-nc.m3u</code>
  - País Vasco <code>https://iptv-org.github.io/iptv/subdivisions/es-pv.m3u</code>
  - Santa Cruz de Tenerife <code>https://iptv-org.github.io/iptv/subdivisions/es-tf.m3u</code>
    - Las Palmas <code>https://iptv-org.github.io/iptv/cities/eslpg.m3u</code>
  - Tarragona <code>https://iptv-org.github.io/iptv/subdivisions/es-t.m3u</code>
    - El Vendrell <code>https://iptv-org.github.io/iptv/cities/esdre.m3u</code>
  - Valencia <code>https://iptv-org.github.io/iptv/subdivisions/es-v.m3u</code>
    - Alzira <code>https://iptv-org.github.io/iptv/cities/esazj.m3u</code>
    - Bocairente <code>https://iptv-org.github.io/iptv/cities/esboi.m3u</code>
  - Valenciana <code>https://iptv-org.github.io/iptv/subdivisions/es-vc.m3u</code>
- 🇱🇰 Sri Lanka <code>https://iptv-org.github.io/iptv/countries/lk.m3u</code>
- 🇸🇩 Sudan <code>https://iptv-org.github.io/iptv/countries/sd.m3u</code>
- 🇸🇷 Suriname <code>https://iptv-org.github.io/iptv/countries/sr.m3u</code>
- 🇸🇪 Sweden <code>https://iptv-org.github.io/iptv/countries/se.m3u</code>
- 🇨🇭 Switzerland <code>https://iptv-org.github.io/iptv/countries/ch.m3u</code>
- 🇸🇾 Syria <code>https://iptv-org.github.io/iptv/countries/sy.m3u</code>
- 🇹🇼 Taiwan <code>https://iptv-org.github.io/iptv/countries/tw.m3u</code>
- 🇹🇯 Tajikistan <code>https://iptv-org.github.io/iptv/countries/tj.m3u</code>
- 🇹🇿 Tanzania <code>https://iptv-org.github.io/iptv/countries/tz.m3u</code>
- 🇹🇭 Thailand <code>https://iptv-org.github.io/iptv/countries/th.m3u</code>
- 🇹🇬 Togo <code>https://iptv-org.github.io/iptv/countries/tg.m3u</code>
- 🇹🇹 Trinidad and Tobago <code>https://iptv-org.github.io/iptv/countries/tt.m3u</code>
- 🇹🇳 Tunisia <code>https://iptv-org.github.io/iptv/countries/tn.m3u</code>
- 🇹🇷 Turkiye <code>https://iptv-org.github.io/iptv/countries/tr.m3u</code>
- 🇹🇲 Turkmenistan <code>https://iptv-org.github.io/iptv/countries/tm.m3u</code>
- 🇻🇮 U.S. Virgin Islands <code>https://iptv-org.github.io/iptv/countries/vi.m3u</code>
- 🇺🇬 Uganda <code>https://iptv-org.github.io/iptv/countries/ug.m3u</code>
- 🇺🇦 Ukraine <code>https://iptv-org.github.io/iptv/countries/ua.m3u</code>
  - Avtonomna Respublika Krym <code>https://iptv-org.github.io/iptv/subdivisions/ua-43.m3u</code>
  - Donetska oblast <code>https://iptv-org.github.io/iptv/subdivisions/ua-14.m3u</code>
  - Khersonska oblast <code>https://iptv-org.github.io/iptv/subdivisions/ua-65.m3u</code>
  - Zaporizka oblast <code>https://iptv-org.github.io/iptv/subdivisions/ua-23.m3u</code>
- 🇦🇪 United Arab Emirates <code>https://iptv-org.github.io/iptv/countries/ae.m3u</code>
- 🇬🇧 United Kingdom <code>https://iptv-org.github.io/iptv/countries/uk.m3u</code>
  - Wales <code>https://iptv-org.github.io/iptv/subdivisions/gb-wls.m3u</code>
- 🇺🇸 United States <code>https://iptv-org.github.io/iptv/countries/us.m3u</code>
  - Alabama <code>https://iptv-org.github.io/iptv/subdivisions/us-al.m3u</code>
    - Birmingham <code>https://iptv-org.github.io/iptv/cities/usbhm.m3u</code>
    - Mobile <code>https://iptv-org.github.io/iptv/cities/usmob.m3u</code>
  - Alaska <code>https://iptv-org.github.io/iptv/subdivisions/us-ak.m3u</code>
    - Juneau <code>https://iptv-org.github.io/iptv/cities/usjnu.m3u</code>
  - Arizona <code>https://iptv-org.github.io/iptv/subdivisions/us-az.m3u</code>
    - Bullhead City <code>https://iptv-org.github.io/iptv/cities/usifp.m3u</code>
    - Glendale <code>https://iptv-org.github.io/iptv/cities/usgda.m3u</code>
    - Phoenix <code>https://iptv-org.github.io/iptv/cities/usphx.m3u</code>
    - Scottsdale <code>https://iptv-org.github.io/iptv/cities/usstz.m3u</code>
    - Tucson <code>https://iptv-org.github.io/iptv/cities/ustuz.m3u</code>
    - Yuma <code>https://iptv-org.github.io/iptv/cities/usyum.m3u</code>
  - Arkansas <code>https://iptv-org.github.io/iptv/subdivisions/us-ar.m3u</code>
    - Fort Smith <code>https://iptv-org.github.io/iptv/cities/usfsm.m3u</code>
    - Little Rock <code>https://iptv-org.github.io/iptv/cities/uslit.m3u</code>
    - Pine Bluff <code>https://iptv-org.github.io/iptv/cities/uspbf.m3u</code>
  - California <code>https://iptv-org.github.io/iptv/subdivisions/us-ca.m3u</code>
    - Arroyo Grande <code>https://iptv-org.github.io/iptv/cities/usag2.m3u</code>
    - Bakersfield <code>https://iptv-org.github.io/iptv/cities/usbfl.m3u</code>
    - Banning <code>https://iptv-org.github.io/iptv/cities/usbng.m3u</code>
    - Beverly Hills <code>https://iptv-org.github.io/iptv/cities/usbvh.m3u</code>
    - Buena Park <code>https://iptv-org.github.io/iptv/cities/usbun.m3u</code>
    - Burbank <code>https://iptv-org.github.io/iptv/cities/usbur.m3u</code>
    - Calabasas <code>https://iptv-org.github.io/iptv/cities/uslbj.m3u</code>
    - Carlsbad <code>https://iptv-org.github.io/iptv/cities/uscld.m3u</code>
    - Ceres <code>https://iptv-org.github.io/iptv/cities/uscrz.m3u</code>
    - Cerritos <code>https://iptv-org.github.io/iptv/cities/uscek.m3u</code>
    - Chatsworth <code>https://iptv-org.github.io/iptv/cities/uscwh.m3u</code>
    - Chino Hills <code>https://iptv-org.github.io/iptv/cities/usch3.m3u</code>
    - Concord <code>https://iptv-org.github.io/iptv/cities/usccr.m3u</code>
    - Costa Mesa <code>https://iptv-org.github.io/iptv/cities/usczm.m3u</code>
    - Cupertino <code>https://iptv-org.github.io/iptv/cities/uscuo.m3u</code>
    - Cypress <code>https://iptv-org.github.io/iptv/cities/uscyq.m3u</code>
    - Del Mar <code>https://iptv-org.github.io/iptv/cities/usdma.m3u</code>
    - El Segundo <code>https://iptv-org.github.io/iptv/cities/usels.m3u</code>
    - Encinitas <code>https://iptv-org.github.io/iptv/cities/usxfe.m3u</code>
    - Eureka <code>https://iptv-org.github.io/iptv/cities/useka.m3u</code>
    - Fairfield <code>https://iptv-org.github.io/iptv/cities/ussuu.m3u</code>
    - Fontana <code>https://iptv-org.github.io/iptv/cities/usxfr.m3u</code>
    - Fort Bragg <code>https://iptv-org.github.io/iptv/cities/usfob.m3u</code>
    - Fresno <code>https://iptv-org.github.io/iptv/cities/usfat.m3u</code>
    - Gilroy <code>https://iptv-org.github.io/iptv/cities/usgir.m3u</code>
    - Glendale <code>https://iptv-org.github.io/iptv/cities/usjgx.m3u</code>
    - Huntington Beach <code>https://iptv-org.github.io/iptv/cities/ushtd.m3u</code>
    - Irvine <code>https://iptv-org.github.io/iptv/cities/usivn.m3u</code>
    - Lakewood <code>https://iptv-org.github.io/iptv/cities/uslqq.m3u</code>
    - Lawndale <code>https://iptv-org.github.io/iptv/cities/uslwj.m3u</code>
    - Lompoc <code>https://iptv-org.github.io/iptv/cities/uslpc.m3u</code>
    - Long Beach <code>https://iptv-org.github.io/iptv/cities/uslgb.m3u</code>
    - Los Angeles <code>https://iptv-org.github.io/iptv/cities/uslax.m3u</code>
    - Los Gatos <code>https://iptv-org.github.io/iptv/cities/uslxx.m3u</code>
    - Lucerne Valley <code>https://iptv-org.github.io/iptv/cities/uslcb.m3u</code>
    - Millbrae <code>https://iptv-org.github.io/iptv/cities/usmba.m3u</code>
    - Monterey <code>https://iptv-org.github.io/iptv/cities/usmy3.m3u</code>
    - Moorpark <code>https://iptv-org.github.io/iptv/cities/usmqk.m3u</code>
    - Morro Bay <code>https://iptv-org.github.io/iptv/cities/usmjk.m3u</code>
    - Nevada City <code>https://iptv-org.github.io/iptv/cities/usnfc.m3u</code>
    - Newport Beach <code>https://iptv-org.github.io/iptv/cities/usjnp.m3u</code>
    - Oakland <code>https://iptv-org.github.io/iptv/cities/usoak.m3u</code>
    - Oceanside <code>https://iptv-org.github.io/iptv/cities/usocn.m3u</code>
    - Ontario <code>https://iptv-org.github.io/iptv/cities/usont.m3u</code>
    - Orange <code>https://iptv-org.github.io/iptv/cities/usjor.m3u</code>
    - Pacifica <code>https://iptv-org.github.io/iptv/cities/uspfq.m3u</code>
    - Palm Springs <code>https://iptv-org.github.io/iptv/cities/uspsp.m3u</code>
    - Palo Alto <code>https://iptv-org.github.io/iptv/cities/uspao.m3u</code>
    - Pinole <code>https://iptv-org.github.io/iptv/cities/usp2c.m3u</code>
    - Placentia <code>https://iptv-org.github.io/iptv/cities/uspcc.m3u</code>
    - Pomona <code>https://iptv-org.github.io/iptv/cities/uspqc.m3u</code>
    - Rancho Cucamonga <code>https://iptv-org.github.io/iptv/cities/usrcu.m3u</code>
    - Riverside <code>https://iptv-org.github.io/iptv/cities/usral.m3u</code>
    - Sacramento <code>https://iptv-org.github.io/iptv/cities/ussac.m3u</code>
    - San Bernardino <code>https://iptv-org.github.io/iptv/cities/ussbt.m3u</code>
    - San Diego <code>https://iptv-org.github.io/iptv/cities/ussan.m3u</code>
    - San Francisco <code>https://iptv-org.github.io/iptv/cities/ussfo.m3u</code>
    - San Jose <code>https://iptv-org.github.io/iptv/cities/ussjc.m3u</code>
    - San Luis Obispo <code>https://iptv-org.github.io/iptv/cities/uscsl.m3u</code>
    - San Rafael <code>https://iptv-org.github.io/iptv/cities/ussrf.m3u</code>
    - Santa Clara <code>https://iptv-org.github.io/iptv/cities/usscz.m3u</code>
    - Santa Cruz <code>https://iptv-org.github.io/iptv/cities/ussru.m3u</code>
    - Santa Maria <code>https://iptv-org.github.io/iptv/cities/ussmx.m3u</code>
    - Santa Monica <code>https://iptv-org.github.io/iptv/cities/ussmo.m3u</code>
    - Seaside <code>https://iptv-org.github.io/iptv/cities/usxlu.m3u</code>
    - Sherman Oaks <code>https://iptv-org.github.io/iptv/cities/ussjj.m3u</code>
    - Sonora <code>https://iptv-org.github.io/iptv/cities/ussor.m3u</code>
    - Stockton <code>https://iptv-org.github.io/iptv/cities/ussck.m3u</code>
    - Temecula <code>https://iptv-org.github.io/iptv/cities/ustmc.m3u</code>
    - Torrance <code>https://iptv-org.github.io/iptv/cities/ustoa.m3u</code>
    - Tracy <code>https://iptv-org.github.io/iptv/cities/ustrc.m3u</code>
    - Vacaville <code>https://iptv-org.github.io/iptv/cities/usvcx.m3u</code>
    - Vallejo <code>https://iptv-org.github.io/iptv/cities/usvlo.m3u</code>
    - Ventura <code>https://iptv-org.github.io/iptv/cities/usvnt.m3u</code>
    - West Hollywood <code>https://iptv-org.github.io/iptv/cities/uswwu.m3u</code>
    - Westminster <code>https://iptv-org.github.io/iptv/cities/uswmz.m3u</code>
    - Whittier <code>https://iptv-org.github.io/iptv/cities/uswhr.m3u</code>
  - Colorado <code>https://iptv-org.github.io/iptv/subdivisions/us-co.m3u</code>
    - Aurora <code>https://iptv-org.github.io/iptv/cities/usauc.m3u</code>
    - Brighton <code>https://iptv-org.github.io/iptv/cities/usbgk.m3u</code>
    - Colorado Springs <code>https://iptv-org.github.io/iptv/cities/uscos.m3u</code>
    - Denver <code>https://iptv-org.github.io/iptv/cities/usden.m3u</code>
    - Fort Collins <code>https://iptv-org.github.io/iptv/cities/usfnl.m3u</code>
    - Golden <code>https://iptv-org.github.io/iptv/cities/usgoe.m3u</code>
    - Lakewood <code>https://iptv-org.github.io/iptv/cities/usljk.m3u</code>
    - Littleton <code>https://iptv-org.github.io/iptv/cities/uslto.m3u</code>
    - Loveland <code>https://iptv-org.github.io/iptv/cities/uslov.m3u</code>
    - Rifle <code>https://iptv-org.github.io/iptv/cities/usril.m3u</code>
    - Thornton <code>https://iptv-org.github.io/iptv/cities/ustht.m3u</code>
  - Connecticut <code>https://iptv-org.github.io/iptv/subdivisions/us-ct.m3u</code>
    - Bloomfield <code>https://iptv-org.github.io/iptv/cities/usaac.m3u</code>
    - Bolton <code>https://iptv-org.github.io/iptv/cities/usbl8.m3u</code>
    - Bridgeport <code>https://iptv-org.github.io/iptv/cities/usbdr.m3u</code>
    - Clinton <code>https://iptv-org.github.io/iptv/cities/usclb.m3u</code>
    - Enfield <code>https://iptv-org.github.io/iptv/cities/usenf.m3u</code>
    - Higganum <code>https://iptv-org.github.io/iptv/cities/ushig.m3u</code>
    - New Canaan <code>https://iptv-org.github.io/iptv/cities/usnwc.m3u</code>
    - New Haven <code>https://iptv-org.github.io/iptv/cities/ushvn.m3u</code>
    - Orange <code>https://iptv-org.github.io/iptv/cities/usorb.m3u</code>
    - Rocky Hill <code>https://iptv-org.github.io/iptv/cities/usrok.m3u</code>
    - Wolcott <code>https://iptv-org.github.io/iptv/cities/usxwo.m3u</code>
  - Delaware <code>https://iptv-org.github.io/iptv/subdivisions/us-de.m3u</code>
    - Georgetown <code>https://iptv-org.github.io/iptv/cities/usged.m3u</code>
    - Wilmington <code>https://iptv-org.github.io/iptv/cities/usilg.m3u</code>
  - District of Columbia <code>https://iptv-org.github.io/iptv/subdivisions/us-dc.m3u</code>
    - Washington <code>https://iptv-org.github.io/iptv/cities/uswas.m3u</code>
  - Florida <code>https://iptv-org.github.io/iptv/subdivisions/us-fl.m3u</code>
    - Bradenton <code>https://iptv-org.github.io/iptv/cities/usbbi.m3u</code>
    - Cape Coral <code>https://iptv-org.github.io/iptv/cities/uscc2.m3u</code>
    - Coral Gables <code>https://iptv-org.github.io/iptv/cities/uscgb.m3u</code>
    - Daytona Beach <code>https://iptv-org.github.io/iptv/cities/usdab.m3u</code>
    - Fernandina Beach <code>https://iptv-org.github.io/iptv/cities/usfeb.m3u</code>
    - Fort Lauderdale <code>https://iptv-org.github.io/iptv/cities/usfll.m3u</code>
    - Fort Myers <code>https://iptv-org.github.io/iptv/cities/usfmy.m3u</code>
    - Fort Pierce <code>https://iptv-org.github.io/iptv/cities/usfpr.m3u</code>
    - Gainesville <code>https://iptv-org.github.io/iptv/cities/usgnv.m3u</code>
    - Jacksonville <code>https://iptv-org.github.io/iptv/cities/usjax.m3u</code>
    - Key West <code>https://iptv-org.github.io/iptv/cities/useyw.m3u</code>
    - Lakeland <code>https://iptv-org.github.io/iptv/cities/uslal.m3u</code>
    - Leesburg <code>https://iptv-org.github.io/iptv/cities/uslee.m3u</code>
    - Miami <code>https://iptv-org.github.io/iptv/cities/usmia.m3u</code>
    - Miami Beach <code>https://iptv-org.github.io/iptv/cities/usiyh.m3u</code>
    - Naples <code>https://iptv-org.github.io/iptv/cities/usapf.m3u</code>
    - New Port Richey <code>https://iptv-org.github.io/iptv/cities/usnrh.m3u</code>
    - North Miami Beach <code>https://iptv-org.github.io/iptv/cities/uszgv.m3u</code>
    - Orlando <code>https://iptv-org.github.io/iptv/cities/usorl.m3u</code>
    - Pompano Beach <code>https://iptv-org.github.io/iptv/cities/usppm.m3u</code>
    - Sanford <code>https://iptv-org.github.io/iptv/cities/ussfb.m3u</code>
    - Tallahassee <code>https://iptv-org.github.io/iptv/cities/ustlh.m3u</code>
    - Tampa <code>https://iptv-org.github.io/iptv/cities/ustpa.m3u</code>
    - West Palm Beach <code>https://iptv-org.github.io/iptv/cities/uspbi.m3u</code>
  - Georgia <code>https://iptv-org.github.io/iptv/subdivisions/us-ga.m3u</code>
    - Athens <code>https://iptv-org.github.io/iptv/cities/usahn.m3u</code>
    - Atlanta <code>https://iptv-org.github.io/iptv/cities/usatl.m3u</code>
    - Cleveland <code>https://iptv-org.github.io/iptv/cities/uscqv.m3u</code>
    - Duluth <code>https://iptv-org.github.io/iptv/cities/usdga.m3u</code>
    - Kingsland <code>https://iptv-org.github.io/iptv/cities/usknl.m3u</code>
    - Macon <code>https://iptv-org.github.io/iptv/cities/usmcn.m3u</code>
    - Monroe <code>https://iptv-org.github.io/iptv/cities/usmoe.m3u</code>
    - Savannah <code>https://iptv-org.github.io/iptv/cities/ussav.m3u</code>
  - Hawaii <code>https://iptv-org.github.io/iptv/subdivisions/us-hi.m3u</code>
    - Honolulu <code>https://iptv-org.github.io/iptv/cities/ushnl.m3u</code>
    - Kahului <code>https://iptv-org.github.io/iptv/cities/usogg.m3u</code>
  - Idaho <code>https://iptv-org.github.io/iptv/subdivisions/us-id.m3u</code>
    - Nampa <code>https://iptv-org.github.io/iptv/cities/usnpa.m3u</code>
  - Illinois <code>https://iptv-org.github.io/iptv/subdivisions/us-il.m3u</code>
    - Champaign <code>https://iptv-org.github.io/iptv/cities/uscmi.m3u</code>
    - Chicago <code>https://iptv-org.github.io/iptv/cities/uschi.m3u</code>
    - West Frankfort <code>https://iptv-org.github.io/iptv/cities/uskft.m3u</code>
  - Indiana <code>https://iptv-org.github.io/iptv/subdivisions/us-in.m3u</code>
    - Indianapolis <code>https://iptv-org.github.io/iptv/cities/usind.m3u</code>
    - Michigan City <code>https://iptv-org.github.io/iptv/cities/usmgc.m3u</code>
  - Iowa <code>https://iptv-org.github.io/iptv/subdivisions/us-ia.m3u</code>
    - Des Moines <code>https://iptv-org.github.io/iptv/cities/usdsm.m3u</code>
    - Ottumwa <code>https://iptv-org.github.io/iptv/cities/usotm.m3u</code>
    - Sioux City <code>https://iptv-org.github.io/iptv/cities/ussux.m3u</code>
  - Kansas <code>https://iptv-org.github.io/iptv/subdivisions/us-ks.m3u</code>
    - Lawrence <code>https://iptv-org.github.io/iptv/cities/uslwc.m3u</code>
    - Wichita <code>https://iptv-org.github.io/iptv/cities/usict.m3u</code>
  - Kentucky <code>https://iptv-org.github.io/iptv/subdivisions/us-ky.m3u</code>
    - Lexington <code>https://iptv-org.github.io/iptv/cities/uslex.m3u</code>
    - Louisville <code>https://iptv-org.github.io/iptv/cities/uslui.m3u</code>
  - Louisiana <code>https://iptv-org.github.io/iptv/subdivisions/us-la.m3u</code>
    - Baton Rouge <code>https://iptv-org.github.io/iptv/cities/usbtr.m3u</code>
    - Hammond <code>https://iptv-org.github.io/iptv/cities/ushlo.m3u</code>
    - Lafayette <code>https://iptv-org.github.io/iptv/cities/uslft.m3u</code>
    - New Orleans <code>https://iptv-org.github.io/iptv/cities/usmsy.m3u</code>
    - West Monroe <code>https://iptv-org.github.io/iptv/cities/uswmx.m3u</code>
  - Maine <code>https://iptv-org.github.io/iptv/subdivisions/us-me.m3u</code>
    - Auburn <code>https://iptv-org.github.io/iptv/cities/usaue.m3u</code>
  - Maryland <code>https://iptv-org.github.io/iptv/subdivisions/us-md.m3u</code>
    - Annapolis <code>https://iptv-org.github.io/iptv/cities/usanp.m3u</code>
    - Baltimore <code>https://iptv-org.github.io/iptv/cities/usbal.m3u</code>
    - Salisbury <code>https://iptv-org.github.io/iptv/cities/ussby.m3u</code>
  - Massachusetts <code>https://iptv-org.github.io/iptv/subdivisions/us-ma.m3u</code>
    - Belmont <code>https://iptv-org.github.io/iptv/cities/usjgt.m3u</code>
    - Boston <code>https://iptv-org.github.io/iptv/cities/usbos.m3u</code>
    - Leominster <code>https://iptv-org.github.io/iptv/cities/uslmr.m3u</code>
    - Worcester <code>https://iptv-org.github.io/iptv/cities/usorh.m3u</code>
  - Michigan <code>https://iptv-org.github.io/iptv/subdivisions/us-mi.m3u</code>
    - Battle Creek <code>https://iptv-org.github.io/iptv/cities/usbtl.m3u</code>
    - Detroit <code>https://iptv-org.github.io/iptv/cities/usdet.m3u</code>
    - Grand Rapids <code>https://iptv-org.github.io/iptv/cities/usgrr.m3u</code>
    - Lansing <code>https://iptv-org.github.io/iptv/cities/uslan.m3u</code>
    - Traverse City <code>https://iptv-org.github.io/iptv/cities/ustvc.m3u</code>
  - Minnesota <code>https://iptv-org.github.io/iptv/subdivisions/us-mn.m3u</code>
    - Apple Valley <code>https://iptv-org.github.io/iptv/cities/usyaw.m3u</code>
    - Maple Grove <code>https://iptv-org.github.io/iptv/cities/usxmg.m3u</code>
    - Minneapolis <code>https://iptv-org.github.io/iptv/cities/usmes.m3u</code>
  - Mississippi <code>https://iptv-org.github.io/iptv/subdivisions/us-ms.m3u</code>
    - Columbus <code>https://iptv-org.github.io/iptv/cities/usubs.m3u</code>
    - Gulfport <code>https://iptv-org.github.io/iptv/cities/usgpt.m3u</code>
    - Jackson <code>https://iptv-org.github.io/iptv/cities/usjan.m3u</code>
  - Missouri <code>https://iptv-org.github.io/iptv/subdivisions/us-mo.m3u</code>
    - Cape Girardeau <code>https://iptv-org.github.io/iptv/cities/uscgi.m3u</code>
    - Columbia <code>https://iptv-org.github.io/iptv/cities/uscou.m3u</code>
    - Jefferson City <code>https://iptv-org.github.io/iptv/cities/usjef.m3u</code>
    - Kansas City <code>https://iptv-org.github.io/iptv/cities/usmkc.m3u</code>
    - Sedalia <code>https://iptv-org.github.io/iptv/cities/usdmo.m3u</code>
  - Montana <code>https://iptv-org.github.io/iptv/subdivisions/us-mt.m3u</code>
    - Billings <code>https://iptv-org.github.io/iptv/cities/usbil.m3u</code>
    - Bozeman <code>https://iptv-org.github.io/iptv/cities/usbzn.m3u</code>
    - Great Falls <code>https://iptv-org.github.io/iptv/cities/usgtf.m3u</code>
    - Helena <code>https://iptv-org.github.io/iptv/cities/ushln.m3u</code>
    - Missoula <code>https://iptv-org.github.io/iptv/cities/usmso.m3u</code>
  - Nebraska <code>https://iptv-org.github.io/iptv/subdivisions/us-ne.m3u</code>
    - Lincoln <code>https://iptv-org.github.io/iptv/cities/uslnk.m3u</code>
    - Omaha <code>https://iptv-org.github.io/iptv/cities/usoma.m3u</code>
  - Nevada <code>https://iptv-org.github.io/iptv/subdivisions/us-nv.m3u</code>
    - Las Vegas <code>https://iptv-org.github.io/iptv/cities/uslas.m3u</code>
  - New Hampshire <code>https://iptv-org.github.io/iptv/subdivisions/us-nh.m3u</code>
    - Derry <code>https://iptv-org.github.io/iptv/cities/usdnp.m3u</code>
    - Manchester <code>https://iptv-org.github.io/iptv/cities/usmht.m3u</code>
    - Nashua <code>https://iptv-org.github.io/iptv/cities/usash.m3u</code>
  - New Jersey <code>https://iptv-org.github.io/iptv/subdivisions/us-nj.m3u</code>
    - Newark <code>https://iptv-org.github.io/iptv/cities/usewr.m3u</code>
    - Newton <code>https://iptv-org.github.io/iptv/cities/usnwn.m3u</code>
    - Paterson <code>https://iptv-org.github.io/iptv/cities/uspat.m3u</code>
    - Teterboro <code>https://iptv-org.github.io/iptv/cities/usteb.m3u</code>
    - Trenton <code>https://iptv-org.github.io/iptv/cities/usttn.m3u</code>
  - New Mexico <code>https://iptv-org.github.io/iptv/subdivisions/us-nm.m3u</code>
    - Albuquerque <code>https://iptv-org.github.io/iptv/cities/usabq.m3u</code>
  - New York <code>https://iptv-org.github.io/iptv/subdivisions/us-ny.m3u</code>
    - Buffalo <code>https://iptv-org.github.io/iptv/cities/usbuf.m3u</code>
    - New York City <code>https://iptv-org.github.io/iptv/cities/usnyc.m3u</code>
    - Riverhead <code>https://iptv-org.github.io/iptv/cities/usrhd.m3u</code>
  - North Carolina <code>https://iptv-org.github.io/iptv/subdivisions/us-nc.m3u</code>
    - Charlotte <code>https://iptv-org.github.io/iptv/cities/usclt.m3u</code>
    - Jacksonville <code>https://iptv-org.github.io/iptv/cities/usoaj.m3u</code>
    - Raleigh <code>https://iptv-org.github.io/iptv/cities/usrag.m3u</code>
    - Wilmington <code>https://iptv-org.github.io/iptv/cities/usilm.m3u</code>
    - Winston-Salem <code>https://iptv-org.github.io/iptv/cities/usint.m3u</code>
  - North Dakota <code>https://iptv-org.github.io/iptv/subdivisions/us-nd.m3u</code>
    - Steele <code>https://iptv-org.github.io/iptv/cities/usndz.m3u</code>
  - Ohio <code>https://iptv-org.github.io/iptv/subdivisions/us-oh.m3u</code>
    - Cincinnati <code>https://iptv-org.github.io/iptv/cities/uscvg.m3u</code>
    - Cleveland <code>https://iptv-org.github.io/iptv/cities/uscle.m3u</code>
    - Dayton <code>https://iptv-org.github.io/iptv/cities/usday.m3u</code>
    - Lima <code>https://iptv-org.github.io/iptv/cities/uslia.m3u</code>
    - Toledo <code>https://iptv-org.github.io/iptv/cities/ustol.m3u</code>
  - Oklahoma <code>https://iptv-org.github.io/iptv/subdivisions/us-ok.m3u</code>
    - Oklahoma City <code>https://iptv-org.github.io/iptv/cities/usokc.m3u</code>
    - Tulsa <code>https://iptv-org.github.io/iptv/cities/ustul.m3u</code>
  - Oregon <code>https://iptv-org.github.io/iptv/subdivisions/us-or.m3u</code>
    - Coos Bay <code>https://iptv-org.github.io/iptv/cities/uscob.m3u</code>
  - Pennsylvania <code>https://iptv-org.github.io/iptv/subdivisions/us-pa.m3u</code>
    - Allentown <code>https://iptv-org.github.io/iptv/cities/usawn.m3u</code>
    - Lancaster <code>https://iptv-org.github.io/iptv/cities/uslns.m3u</code>
    - Philadelphia <code>https://iptv-org.github.io/iptv/cities/usphl.m3u</code>
    - Pittsburgh <code>https://iptv-org.github.io/iptv/cities/uspit.m3u</code>
    - West Chester <code>https://iptv-org.github.io/iptv/cities/uswct.m3u</code>
  - Rhode Island <code>https://iptv-org.github.io/iptv/subdivisions/us-ri.m3u</code>
    - Cranston <code>https://iptv-org.github.io/iptv/cities/uscqh.m3u</code>
  - South Carolina <code>https://iptv-org.github.io/iptv/subdivisions/us-sc.m3u</code>
    - Columbia <code>https://iptv-org.github.io/iptv/cities/uscae.m3u</code>
    - Greenville <code>https://iptv-org.github.io/iptv/cities/usgv9.m3u</code>
  - Tennessee <code>https://iptv-org.github.io/iptv/subdivisions/us-tn.m3u</code>
    - Chattanooga <code>https://iptv-org.github.io/iptv/cities/uscha.m3u</code>
    - Jackson <code>https://iptv-org.github.io/iptv/cities/usmkl.m3u</code>
    - Memphis <code>https://iptv-org.github.io/iptv/cities/usmem.m3u</code>
    - Nashville <code>https://iptv-org.github.io/iptv/cities/usbna.m3u</code>
  - Texas <code>https://iptv-org.github.io/iptv/subdivisions/us-tx.m3u</code>
    - Austin <code>https://iptv-org.github.io/iptv/cities/usaus.m3u</code>
    - Corpus Christi <code>https://iptv-org.github.io/iptv/cities/uscrp.m3u</code>
    - Dallas <code>https://iptv-org.github.io/iptv/cities/usdal.m3u</code>
    - El Paso <code>https://iptv-org.github.io/iptv/cities/uselp.m3u</code>
    - Fort Worth <code>https://iptv-org.github.io/iptv/cities/usfwt.m3u</code>
    - Fredericksburg <code>https://iptv-org.github.io/iptv/cities/usfxg.m3u</code>
    - Galveston <code>https://iptv-org.github.io/iptv/cities/usgls.m3u</code>
    - Houston <code>https://iptv-org.github.io/iptv/cities/ushou.m3u</code>
    - San Angelo <code>https://iptv-org.github.io/iptv/cities/ussjt.m3u</code>
    - Snyder <code>https://iptv-org.github.io/iptv/cities/ussnk.m3u</code>
    - Waco <code>https://iptv-org.github.io/iptv/cities/usact.m3u</code>
    - Weslaco <code>https://iptv-org.github.io/iptv/cities/uswko.m3u</code>
  - Utah <code>https://iptv-org.github.io/iptv/subdivisions/us-ut.m3u</code>
    - Salt Lake City <code>https://iptv-org.github.io/iptv/cities/usslc.m3u</code>
  - Virginia <code>https://iptv-org.github.io/iptv/subdivisions/us-va.m3u</code>
    - Harrisonburg <code>https://iptv-org.github.io/iptv/cities/ushbv.m3u</code>
    - Norfolk <code>https://iptv-org.github.io/iptv/cities/usorf.m3u</code>
    - Richmond <code>https://iptv-org.github.io/iptv/cities/usric.m3u</code>
    - Roanoke <code>https://iptv-org.github.io/iptv/cities/usroa.m3u</code>
  - Washington <code>https://iptv-org.github.io/iptv/subdivisions/us-wa.m3u</code>
    - Seattle <code>https://iptv-org.github.io/iptv/cities/ussea.m3u</code>
    - Tacoma <code>https://iptv-org.github.io/iptv/cities/ustiw.m3u</code>
  - Wisconsin <code>https://iptv-org.github.io/iptv/subdivisions/us-wi.m3u</code>
    - Green Bay <code>https://iptv-org.github.io/iptv/cities/usgrb.m3u</code>
    - Milwaukee <code>https://iptv-org.github.io/iptv/cities/usmke.m3u</code>
- 🇺🇾 Uruguay <code>https://iptv-org.github.io/iptv/countries/uy.m3u</code>
- 🇺🇿 Uzbekistan <code>https://iptv-org.github.io/iptv/countries/uz.m3u</code>
- 🇻🇦 Vatican City <code>https://iptv-org.github.io/iptv/countries/va.m3u</code>
- 🇻🇪 Venezuela <code>https://iptv-org.github.io/iptv/countries/ve.m3u</code>
  - Aragua <code>https://iptv-org.github.io/iptv/subdivisions/ve-d.m3u</code>
    - Maracay <code>https://iptv-org.github.io/iptv/cities/vemyc.m3u</code>
  - Lara <code>https://iptv-org.github.io/iptv/subdivisions/ve-k.m3u</code>
- 🇻🇳 Vietnam <code>https://iptv-org.github.io/iptv/countries/vn.m3u</code>
- 🇪🇭 Western Sahara <code>https://iptv-org.github.io/iptv/countries/eh.m3u</code>
- 🇾🇪 Yemen <code>https://iptv-org.github.io/iptv/countries/ye.m3u</code>
- 🇿🇲 Zambia <code>https://iptv-org.github.io/iptv/countries/zm.m3u</code>
- 🇿🇼 Zimbabwe <code>https://iptv-org.github.io/iptv/countries/zw.m3u</code>
- 🌐 International <code>https://iptv-org.github.io/iptv/countries/int.m3u</code>
- Undefined <code>https://iptv-org.github.io/iptv/countries/undefined.m3u</code>

#### Regions

<!-- prettier-ignore -->
- Africa <code>https://iptv-org.github.io/iptv/regions/afr.m3u</code>
- Americas <code>https://iptv-org.github.io/iptv/regions/amer.m3u</code>
- Arab world <code>https://iptv-org.github.io/iptv/regions/arab.m3u</code>
- Asia <code>https://iptv-org.github.io/iptv/regions/asia.m3u</code>
- Asia-Pacific <code>https://iptv-org.github.io/iptv/regions/apac.m3u</code>
- Association of Southeast Asian Nations <code>https://iptv-org.github.io/iptv/regions/asean.m3u</code>
- Balkan <code>https://iptv-org.github.io/iptv/regions/balkan.m3u</code>
- Benelux <code>https://iptv-org.github.io/iptv/regions/benelux.m3u</code>
- Caribbean <code>https://iptv-org.github.io/iptv/regions/carib.m3u</code>
- Central America <code>https://iptv-org.github.io/iptv/regions/cenamer.m3u</code>
- Central and Eastern Europe <code>https://iptv-org.github.io/iptv/regions/cee.m3u</code>
- Central Asia <code>https://iptv-org.github.io/iptv/regions/cas.m3u</code>
- Central Europe <code>https://iptv-org.github.io/iptv/regions/ceu.m3u</code>
- Commonwealth of Independent States <code>https://iptv-org.github.io/iptv/regions/cis.m3u</code>
- East Africa <code>https://iptv-org.github.io/iptv/regions/eaf.m3u</code>
- East Asia <code>https://iptv-org.github.io/iptv/regions/eas.m3u</code>
- Europe <code>https://iptv-org.github.io/iptv/regions/eur.m3u</code>
- Europe, the Middle East and Africa <code>https://iptv-org.github.io/iptv/regions/emea.m3u</code>
- European Union <code>https://iptv-org.github.io/iptv/regions/eu.m3u</code>
- Gulf Cooperation Council <code>https://iptv-org.github.io/iptv/regions/gcc.m3u</code>
- Hispanic America <code>https://iptv-org.github.io/iptv/regions/hispam.m3u</code>
- Latin America <code>https://iptv-org.github.io/iptv/regions/latam.m3u</code>
- Latin America and the Caribbean <code>https://iptv-org.github.io/iptv/regions/lac.m3u</code>
- Maghreb <code>https://iptv-org.github.io/iptv/regions/maghreb.m3u</code>
- Middle East <code>https://iptv-org.github.io/iptv/regions/mideast.m3u</code>
- Middle East and North Africa <code>https://iptv-org.github.io/iptv/regions/mena.m3u</code>
- Nordics <code>https://iptv-org.github.io/iptv/regions/nord.m3u</code>
- North America <code>https://iptv-org.github.io/iptv/regions/noram.m3u</code>
- Northern America <code>https://iptv-org.github.io/iptv/regions/nam.m3u</code>
- Northern Europe <code>https://iptv-org.github.io/iptv/regions/neu.m3u</code>
- Oceania <code>https://iptv-org.github.io/iptv/regions/oce.m3u</code>
- South America <code>https://iptv-org.github.io/iptv/regions/southam.m3u</code>
- South Asia <code>https://iptv-org.github.io/iptv/regions/sas.m3u</code>
- Southeast Asia <code>https://iptv-org.github.io/iptv/regions/sea.m3u</code>
- Southern Africa <code>https://iptv-org.github.io/iptv/regions/saf.m3u</code>
- Southern Europe <code>https://iptv-org.github.io/iptv/regions/ser.m3u</code>
- Sub-Saharan Africa <code>https://iptv-org.github.io/iptv/regions/ssa.m3u</code>
- United Nations <code>https://iptv-org.github.io/iptv/regions/un.m3u</code>
- West Africa <code>https://iptv-org.github.io/iptv/regions/waf.m3u</code>
- West Asia <code>https://iptv-org.github.io/iptv/regions/was.m3u</code>
- Western Europe <code>https://iptv-org.github.io/iptv/regions/wer.m3u</code>
- Worldwide <code>https://iptv-org.github.io/iptv/regions/ww.m3u</code>

</details>

### Grouped by sources

Playlists in which channels are grouped by broadcast source.

<details>
<summary>Expand</summary>
<br>

To use the playlist, simply replace `<FILENAME>` in the link below with the name of one of the files in the [streams](streams) folder.

```
https://iptv-org.github.io/iptv/sources/<FILENAME>.m3u
```

</details>

Also, any of our internal playlists are available in raw form (without any filtering or sorting) at this link:

```
https://iptv-org.github.io/iptv/raw/<FILENAME>.m3u
```
